/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.RegexpPropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeRegexp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class RegexpValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -2387465714767785072L;
    private final JPanel panel = new JPanel();
    private final JTextField textField = new JTextField(12);
    private Operator operator;

    public RegexpValueCellEditor(final ParameterTypeRegexp type) {
        this.panel.setLayout(new GridBagLayout());
        this.panel.setToolTipText(type.getDescription());
        this.textField.setToolTipText(type.getDescription());
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegexpValueCellEditor.this.fireEditingStopped();
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                RegexpValueCellEditor.this.fireEditingStopped();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.panel.add((Component)this.textField, c);
        JButton button = new JButton(new ResourceAction(true, "regexp", new Object[0]){
            private static final long serialVersionUID = 3989811306286704326L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RegexpPropertyDialog dialog = new RegexpPropertyDialog(type, RegexpValueCellEditor.this.textField.getText(), RegexpValueCellEditor.this.operator);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    RegexpValueCellEditor.this.textField.setText(dialog.getRegexp());
                    RegexpValueCellEditor.this.fireEditingStopped();
                } else {
                    RegexpValueCellEditor.this.fireEditingCanceled();
                }
            }
        });
        button.setMargin(new Insets(0, 0, 0, 0));
        c.weightx = 0.0;
        this.panel.add((Component)button, c);
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText();
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(value == null ? "" : value.toString());
        return this.panel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.textField.setText(value == null ? "" : value.toString());
        return this.panel;
    }
}

