/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.wizards.PreviewCreator;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypePreview;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class PreviewValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -7163760967040772736L;
    private transient ParameterTypePreview type;
    private JButton button;

    public PreviewValueCellEditor(ParameterTypePreview type) {
        this.type = type;
        this.button = new JButton("Show Preview...");
        this.button.setToolTipText(type.getDescription());
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewValueCellEditor.this.buttonPressed();
            }
        });
    }

    @Override
    public void setOperator(Operator operator) {
    }

    private void buttonPressed() {
        PreviewCreator creator = this.type.getPreviewCreator();
        if (creator != null) {
            creator.createPreview(this.type.getPreviewListener());
        }
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        return this.button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }
}

