/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeTupel;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class ParameterTupelCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -2387465714767785072L;
    private JPanel panel;
    private ParameterType[] types;
    private PropertyValueCellEditor[] editors;
    private Operator operator;

    public ParameterTupelCellEditor(ParameterTypeTupel type) {
        this.types = type.getParameterTypes();
    }

    @Override
    public Object getCellEditorValue() {
        String[] values = new String[this.editors.length];
        for (int i = 0; i < this.editors.length; ++i) {
            if (this.editors[i].getCellEditorValue() == null) continue;
            values[i] = this.editors[i].getCellEditorValue().toString();
        }
        return ParameterTypeTupel.transformTupel2String(values);
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String[] tupel = value instanceof String ? ParameterTypeTupel.transformString2Tupel((String)value) : (String[])value;
        if (this.panel == null) {
            this.constructPanel(tupel);
        }
        for (int i = 0; i < this.editors.length; ++i) {
            this.editors[i].getTableCellEditorComponent(null, tupel[i], false, 0, 0);
        }
        return this.panel;
    }

    private void constructPanel(String[] values) {
        int i;
        this.editors = new PropertyValueCellEditor[this.types.length];
        for (i = 0; i < this.types.length; ++i) {
            this.editors[i] = PropertyPanel.instantiateValueCellEditor(this.types[i], this.operator);
            this.editors[i].addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                    ParameterTupelCellEditor.this.fireEditingCanceled();
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    ParameterTupelCellEditor.this.fireEditingStopped();
                }
            });
        }
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(1, this.editors.length));
        for (i = 0; i < this.types.length; ++i) {
            Component editorComponent = this.editors[i].getTableCellEditorComponent(null, values[i], false, 0, 0);
            this.panel.add(editorComponent);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String[] tupel = value instanceof String ? ParameterTypeTupel.transformString2Tupel((String)value) : (String[])value;
        if (this.panel == null) {
            this.constructPanel(tupel);
        }
        for (int i = 0; i < this.editors.length; ++i) {
            this.editors[i].getTableCellEditorComponent(null, tupel[i], false, 0, 0);
        }
        return this.panel;
    }
}

