/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.Process;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.Value;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeValue;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OperatorValueValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 2332956173516489926L;
    private JPanel panel = new JPanel();
    private JComboBox operatorCombo;
    private JComboBox typeCombo = new JComboBox<String>(new String[]{"value", "parameter"});
    private JComboBox valueCombo = new JComboBox();
    private transient Process process;

    public OperatorValueValueCellEditor(ParameterTypeValue type) {
    }

    @Override
    public void setOperator(Operator operator) {
        this.process = operator.getProcess();
        this.operatorCombo = this.createOperatorCombo();
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorValueValueCellEditor.this.fillValueCombo();
                OperatorValueValueCellEditor.this.fireEditingStopped();
            }
        });
        this.valueCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorValueValueCellEditor.this.fireEditingStopped();
            }
        });
        this.fillValueCombo();
        this.panel.setLayout(new GridLayout(1, 3));
        this.panel.add(this.operatorCombo);
        this.panel.add(this.typeCombo);
        this.panel.add(this.valueCombo);
    }

    private JComboBox createOperatorCombo() {
        Vector<String> allOps = new Vector<String>(this.process.getAllOperatorNames());
        Collections.sort(allOps);
        JComboBox<String> combo = new JComboBox<String>(allOps);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorValueValueCellEditor.this.fillValueCombo();
                OperatorValueValueCellEditor.this.fireEditingStopped();
            }
        });
        return combo;
    }

    private void fillValueCombo() {
        this.valueCombo.removeAllItems();
        Operator operator = this.process.getOperator((String)this.operatorCombo.getSelectedItem());
        switch (this.typeCombo.getSelectedIndex()) {
            case 0: {
                Iterator<Value> i = operator.getValues().iterator();
                while (i.hasNext()) {
                    this.valueCombo.addItem(i.next().getKey());
                }
                if (this.valueCombo.getItemCount() != 0) break;
                this.valueCombo.addItem("no values");
                break;
            }
            case 1: {
                Iterator<ParameterType> i = operator.getParameters().getParameterTypes().iterator();
                while (i.hasNext()) {
                    this.valueCombo.addItem(i.next().getKey());
                }
                if (this.valueCombo.getItemCount() != 0) break;
                this.valueCombo.addItem("no params");
            }
        }
        this.valueCombo.setSelectedIndex(0);
    }

    @Override
    public Object getCellEditorValue() {
        ParameterTypeValue.OperatorValueSelection selection = new ParameterTypeValue.OperatorValueSelection((String)this.operatorCombo.getSelectedItem(), this.typeCombo.getSelectedIndex() == 0, (String)this.valueCombo.getSelectedItem());
        return ParameterTypeValue.transformOperatorValueSelection2String(selection);
    }

    public void setValue(String valueName) {
        if (valueName != null) {
            ParameterTypeValue.OperatorValueSelection selection = ParameterTypeValue.transformString2OperatorValueSelection(valueName);
            if (selection != null) {
                this.operatorCombo.setSelectedItem(selection.getOperator());
                this.typeCombo.setSelectedIndex(selection.isValue() ? 0 : 1);
                this.valueCombo.setSelectedItem(selection.isValue() ? selection.getValueName() : selection.getParameterName());
            } else {
                this.operatorCombo.setSelectedIndex(0);
                this.typeCombo.setSelectedIndex(0);
                this.valueCombo.setSelectedIndex(0);
            }
        } else {
            this.operatorCombo.setSelectedIndex(0);
            this.typeCombo.setSelectedIndex(0);
            this.valueCombo.setSelectedIndex(0);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setValue((String)value);
        return this.panel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }
}

