/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.MatrixPropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeMatrix;
import com.rapidminer.tools.math.StringToMatrixConverter;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class MatrixValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 0L;
    private ParameterTypeMatrix type;
    private Operator operator;
    private JButton button = new JButton(new ResourceAction(true, "matrix.edit", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MatrixPropertyDialog dialog = new MatrixPropertyDialog(MatrixValueCellEditor.this.type, MatrixValueCellEditor.this.matrix, MatrixValueCellEditor.this.operator);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                MatrixValueCellEditor.access$102(MatrixValueCellEditor.this, dialog.getMatrix());
                MatrixValueCellEditor.this.fireEditingStopped();
                MatrixValueCellEditor.this.setButtonText();
            } else {
                MatrixValueCellEditor.this.fireEditingCanceled();
            }
        }
    });
    private double[][] matrix;

    public MatrixValueCellEditor(ParameterTypeMatrix type) {
        this.type = type;
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setToolTipText(type.getDescription());
        this.setButtonText();
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public Object getCellEditorValue() {
        return StringToMatrixConverter.createMatlabString(this.matrix);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        try {
            this.matrix = StringToMatrixConverter.parseMatlabString((String)value);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setButtonText();
        return this.button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    private void setButtonText() {
        if (this.matrix != null) {
            this.button.setText("Edit Matrix (" + this.matrix.length + " x " + this.matrix[0].length + ")...");
        } else {
            this.button.setText("Edit Matrix...");
        }
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    static /* synthetic */ double[][] access$102(MatrixValueCellEditor x0, double[][] x1) {
        x0.matrix = x1;
        return x1;
    }
}

