/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.ListPropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeList;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class ListValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -4429790999365057931L;
    private ParameterTypeList type;
    private JButton button;
    private List<String[]> valuesList = new LinkedList<String[]>();

    public ListValueCellEditor(ParameterTypeList type) {
        this.type = type;
    }

    @Override
    public void setOperator(final Operator operator) {
        this.button = new JButton(new ResourceAction(true, "list", new Object[0]){
            private static final long serialVersionUID = 3546416469350908571L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPropertyDialog dialog = new ListPropertyDialog(ListValueCellEditor.this.type, ListValueCellEditor.this.valuesList, operator);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    ListValueCellEditor.this.fireEditingStopped();
                    ListValueCellEditor.this.setButtonText();
                } else {
                    ListValueCellEditor.this.fireEditingCanceled();
                }
            }
        });
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.setButtonText();
    }

    @Override
    public Object getCellEditorValue() {
        return this.valuesList;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.valuesList = ParameterTypeList.transformString2List((String)value);
        this.setButtonText();
        return this.button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    private void setButtonText() {
        this.button.setText("Edit List (" + this.valuesList.size() + ")...");
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }
}

