/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.parameter.ParameterTypeInnerOperator;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

public class InnerOperatorValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -2559892872774108384L;
    private JComboBox operatorCombo = new JComboBox();
    private transient OperatorChain parentOperator;

    public InnerOperatorValueCellEditor(ParameterTypeInnerOperator type) {
    }

    @Override
    public void setOperator(Operator parentOperator) {
        this.parentOperator = (OperatorChain)parentOperator;
        this.operatorCombo = new JComboBox();
        this.updateOperatorCombo();
    }

    private void updateOperatorCombo() {
        Object selectedItem = this.operatorCombo.getSelectedItem();
        this.operatorCombo.removeAllItems();
        List<Operator> allInnerOps = this.parentOperator.getAllInnerOperators();
        Vector<String> allOpNames = new Vector<String>();
        Iterator<Operator> i = allInnerOps.iterator();
        while (i.hasNext()) {
            allOpNames.add(i.next().getName());
        }
        Collections.sort(allOpNames);
        Iterator s = allOpNames.iterator();
        while (s.hasNext()) {
            this.operatorCombo.addItem(s.next());
        }
        this.operatorCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InnerOperatorValueCellEditor.this.fireEditingStopped();
            }
        });
        if (this.operatorCombo.getItemCount() == 0) {
            this.operatorCombo.addItem("add inner operators");
        }
        this.operatorCombo.setSelectedItem(selectedItem);
    }

    @Override
    public Object getCellEditorValue() {
        return this.operatorCombo.getSelectedItem();
    }

    public void setValue(String valueName) {
        if (valueName != null) {
            this.operatorCombo.setSelectedItem(valueName);
        } else {
            this.operatorCombo.setSelectedIndex(0);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setValue((String)value);
        return this.operatorCombo;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }
}

