/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public abstract class FileValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -8235047960089702819L;
    private final JPanel panel = new JPanel();
    private final JTextField textField = new JTextField(12);
    private final ParameterTypeFile type;
    private final GridBagLayout gridBagLayout = new GridBagLayout();

    public FileValueCellEditor(ParameterTypeFile type) {
        this.type = type;
        this.panel.setLayout(this.gridBagLayout);
        this.panel.setToolTipText(type.getDescription());
        this.textField.setToolTipText(type.getDescription());
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileValueCellEditor.this.fireEditingStopped();
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                FileValueCellEditor.this.fireEditingStopped();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.gridBagLayout.setConstraints(this.textField, c);
        this.panel.add(this.textField);
    }

    protected JButton createFileChooserButton() {
        JButton button = new JButton(new ResourceAction(true, "choose_file", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FileValueCellEditor.this.buttonPressed();
            }
        });
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    protected void addButton(JButton button, int gridwidth) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = gridwidth;
        c.weightx = 0.0;
        c.fill = 1;
        this.gridBagLayout.setConstraints(button, c);
        this.panel.add(button);
    }

    private void buttonPressed() {
        String value = (String)this.getCellEditorValue();
        File file = value == null || value.length() == 0 ? null : RapidMinerGUI.getMainFrame().getProcess().resolveFileName(value);
        File selectedFile = SwingTools.chooseFile((Component)RapidMinerGUI.getMainFrame(), file, true, this.type instanceof ParameterTypeDirectory, this.type.getExtension(), this.type.getKey());
        if (selectedFile != null) {
            this.setText(selectedFile);
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
    }

    protected void setText(File file) {
        if (file == null) {
            this.textField.setText("");
        } else {
            this.textField.setText(file.getPath());
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText().trim().length() == 0 ? null : this.textField.getText().trim();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.textField.setText(value == null ? "" : value.toString());
        return this.panel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }
}

