/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.ExpressionPropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeExpression;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ExpressionValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 2355429695124754211L;
    private static final String CALCULATOR_NAME = "calculator.png";
    private static Icon CALCULATOR_ICON = null;
    private final JPanel panel = new JPanel();
    private final JTextField textField = new JTextField(12);
    private final ParameterTypeExpression type;
    private final GridBagLayout gridBagLayout = new GridBagLayout();

    public ExpressionValueCellEditor(ParameterTypeExpression type) {
        this.type = type;
        this.panel.setLayout(this.gridBagLayout);
        this.panel.setToolTipText(type.getDescription());
        this.textField.setToolTipText(type.getDescription());
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionValueCellEditor.this.fireEditingStopped();
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ExpressionValueCellEditor.this.fireEditingStopped();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.gridBagLayout.setConstraints(this.textField, c);
        this.panel.add(this.textField);
        JButton button = new JButton(CALCULATOR_ICON);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionValueCellEditor.this.buttonPressed();
            }
        });
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.gridBagLayout.setConstraints(button, c);
        this.panel.add(button);
    }

    private void buttonPressed() {
        Object value = this.getCellEditorValue();
        String initial = value == null ? null : value.toString();
        ExpressionPropertyDialog dialog = new ExpressionPropertyDialog(this.type, initial);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            this.setText(dialog.getExpression());
        }
        this.fireEditingStopped();
    }

    protected void setText(String text) {
        if (text == null) {
            this.textField.setText("");
        } else {
            this.textField.setText(text);
        }
    }

    @Override
    public void setOperator(Operator operator) {
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText().trim().length() == 0 ? null : this.textField.getText().trim();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.textField.setText(value == null ? "" : value.toString());
        return this.panel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    static {
        CALCULATOR_ICON = SwingTools.createIcon("16/calculator.png");
    }
}

