/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.EnumerationPropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class EnumerationValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -4429790999365057931L;
    private ParameterTypeEnumeration type;
    private JButton button;
    private List<String> valuesList = new LinkedList<String>();

    public EnumerationValueCellEditor(ParameterTypeEnumeration type) {
        this.type = type;
    }

    @Override
    public void setOperator(final Operator operator) {
        this.button = new JButton(new ResourceAction(true, "enumeration", new Object[0]){
            private static final long serialVersionUID = 3163983383358779866L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumerationPropertyDialog dialog = new EnumerationPropertyDialog(EnumerationValueCellEditor.this.type, EnumerationValueCellEditor.this.valuesList, operator);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    EnumerationValueCellEditor.this.fireEditingStopped();
                    EnumerationValueCellEditor.this.setButtonText();
                } else {
                    EnumerationValueCellEditor.this.fireEditingCanceled();
                }
            }
        });
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.setButtonText();
    }

    @Override
    public Object getCellEditorValue() {
        return ParameterTypeEnumeration.transformEnumeration2String(this.valuesList);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        if (value != null) {
            LinkedList<String> values = new LinkedList<String>();
            for (String string : ParameterTypeEnumeration.transformString2Enumeration((String)value)) {
                values.add(string);
            }
            this.valuesList = values;
        } else {
            this.valuesList = new LinkedList<String>();
        }
        this.setButtonText();
        return this.button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    private void setButtonText() {
        this.button.setText("Edit Enumeration (" + this.valuesList.size() + ")...");
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }
}

