/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.CharTextField;
import com.rapidminer.gui.tools.ExtendedJComboBox;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.autocomplete.AutoCompleteComboBoxAddition;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeChar;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DefaultPropertyValueCellEditor
extends DefaultCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 3594466409311826645L;
    private static final int TEXT_FIELD_WIDTH = 10;
    private boolean useEditorAsRenderer = false;
    private boolean rendersLabel = false;

    public DefaultPropertyValueCellEditor(final ParameterTypeCategory type) {
        super(new ExtendedJComboBox(type.getValues()));
        this.useEditorAsRenderer = true;
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = -2104662561680969750L;

            @Override
            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedIndex(-1);
                } else {
                    try {
                        Integer index = Integer.valueOf(x.toString());
                        super.setValue(index);
                        ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedIndex(index);
                    }
                    catch (NumberFormatException e) {
                        int index = type.getIndex(x.toString());
                        super.setValue(index);
                        ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedIndex(index);
                    }
                }
            }

            @Override
            public Object getCellEditorValue() {
                return ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).getSelectedItem();
            }
        };
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeStringCategory type) {
        super(new JComboBox<String>(type.getValues()));
        if (type.isEditable()) {
            AutoCompleteComboBoxAddition autoCompleteCBA = new AutoCompleteComboBoxAddition((JComboBox)this.editorComponent);
            autoCompleteCBA.setCaseSensitive(false);
        }
        final JTextComponent textField = (JTextComponent)((JComboBox)this.editorComponent).getEditor().getEditorComponent();
        this.useEditorAsRenderer = true;
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        ((JComboBox)this.editorComponent).setEditable(type.isEditable());
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = -5592150438626222295L;

            @Override
            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedItem(null);
                } else {
                    String value = x.toString();
                    super.setValue(value);
                    ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedItem(value);
                    if (value != null) {
                        textField.setText(value.toString());
                    } else {
                        textField.setText("");
                    }
                }
            }

            @Override
            public Object getCellEditorValue() {
                if (type.isEditable()) {
                    String selected = textField.getText();
                    if (selected != null && selected.trim().length() == 0) {
                        selected = null;
                    }
                    return selected;
                }
                return ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).getSelectedItem();
            }
        };
        this.editorComponent.setToolTipText(type.getDescription());
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeBoolean type) {
        super(new JCheckBox());
        this.rendersLabel = true;
        ((JCheckBox)this.editorComponent).setHorizontalAlignment(0);
        ((JCheckBox)this.editorComponent).setText(type.getKey().replace('_', ' '));
        if (type.isExpert()) {
            this.editorComponent.setFont(this.editorComponent.getFont().deriveFont(2));
        }
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = 152467444047540403L;

            @Override
            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JCheckBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelected((Boolean)type.getDefaultValue());
                } else {
                    Boolean value = Tools.booleanValue(x.toString(), (Boolean)type.getDefaultValue());
                    super.setValue(value);
                    ((JCheckBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelected(value);
                }
            }

            @Override
            public Object getCellEditorValue() {
                return Boolean.valueOf(Tools.booleanValue(Boolean.valueOf(((JCheckBox)DefaultPropertyValueCellEditor.this.editorComponent).isSelected()).toString(), (Boolean)type.getDefaultValue())).toString();
            }
        };
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeInt type) {
        super(new JTextField(10));
        this.editorComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DefaultPropertyValueCellEditor.this.fireEditingStopped();
            }
        });
        ((JTextField)this.editorComponent).setHorizontalAlignment(2);
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = 152467444047540403L;

            @Override
            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                } else {
                    super.setValue(x.toString());
                    try {
                        if (this.value != null) {
                            Integer value = Integer.valueOf(x.toString());
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(value.toString());
                        } else {
                            Integer defaultValue = (Integer)type.getDefaultValue();
                            if (defaultValue != null) {
                                ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                            } else {
                                ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        String text = x.toString();
                        if (text.startsWith("%{") && text.endsWith("}")) {
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(text);
                        }
                        Integer defaultValue = (Integer)type.getDefaultValue();
                        if (defaultValue != null) {
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                        }
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                    }
                }
            }

            @Override
            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                try {
                    int i = Integer.parseInt(text);
                    if ((double)i < type.getMinValue()) {
                        i = (int)type.getMinValue();
                    }
                    if ((double)i > type.getMaxValue()) {
                        i = (int)type.getMaxValue();
                    }
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(Integer.valueOf(i).toString());
                    return Integer.valueOf(i).toString();
                }
                catch (NumberFormatException e) {
                    if (text.startsWith("%{") && text.endsWith("}")) {
                        return text;
                    }
                    Integer defaultValue = (Integer)type.getDefaultValue();
                    if (defaultValue != null) {
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                        return type.getDefaultValue();
                    }
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText("");
                    return null;
                }
            }
        };
        this.editorComponent.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeDouble type) {
        super(new JTextField(10));
        this.editorComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DefaultPropertyValueCellEditor.this.fireEditingStopped();
            }
        });
        ((JTextField)this.editorComponent).setHorizontalAlignment(2);
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = 5764937097891322370L;

            @Override
            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                } else {
                    super.setValue(x.toString());
                    try {
                        if (this.value != null) {
                            Double value = Double.valueOf(x.toString());
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(value.toString());
                        } else {
                            Double defaultValue = (Double)type.getDefaultValue();
                            if (defaultValue != null) {
                                ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                            } else {
                                ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        String text = x.toString();
                        if (text.startsWith("%{") && text.endsWith("}")) {
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(text);
                        }
                        Double defaultValue = (Double)type.getDefaultValue();
                        if (defaultValue != null) {
                            ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                        }
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                    }
                }
            }

            @Override
            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                try {
                    double d = Double.parseDouble(text);
                    if (d < type.getMinValue()) {
                        d = type.getMinValue();
                    }
                    if (d > type.getMaxValue()) {
                        d = type.getMaxValue();
                    }
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(Double.valueOf(d).toString());
                    return Double.valueOf(d).toString();
                }
                catch (NumberFormatException e) {
                    if (text.startsWith("%{") && text.endsWith("}")) {
                        return text;
                    }
                    Double defaultValue = (Double)type.getDefaultValue();
                    if (defaultValue != null) {
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(type.getDefaultValue().toString());
                        return type.getDefaultValue();
                    }
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText("");
                    return null;
                }
            }
        };
        this.editorComponent.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterTypePassword type) {
        super(new JPasswordField());
        this.editorComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DefaultPropertyValueCellEditor.this.fireEditingStopped();
            }
        });
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = -2736861014783898296L;

            @Override
            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(null);
                } else {
                    String value = x.toString();
                    super.setValue(value);
                    if (x != null) {
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(value.toString());
                    }
                }
            }

            @Override
            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                if (text == null || text.length() == 0) {
                    if (type.getDefaultValue() != null) {
                        return type.getDefaultValue().toString();
                    }
                    return null;
                }
                return text.toString();
            }
        };
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(ParameterTypeChar type) {
        super(new CharTextField());
        this.editorComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DefaultPropertyValueCellEditor.this.fireEditingStopped();
            }
        });
    }

    public DefaultPropertyValueCellEditor(final ParameterType type) {
        super(new JTextField(10));
        this.editorComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DefaultPropertyValueCellEditor.this.fireEditingStopped();
            }
        });
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = -2868203350553070093L;

            @Override
            public void setValue(Object x) {
                super.setValue(x);
                if (x != null) {
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(x.toString());
                }
            }

            @Override
            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                if (text == null || text.length() == 0) {
                    if (type.getDefaultValue() == null) {
                        return null;
                    }
                    return type.toString(type.getDefaultValue());
                }
                return text.toString();
            }
        };
        this.useEditorAsRenderer = true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component c;
        if (table == null) {
            c = this.editorComponent;
            this.delegate.setValue(value);
            ((JComponent)c).setOpaque(!(c instanceof JCheckBox) && !(c instanceof JComboBox));
        } else {
            c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        if (isSelected) {
            c.setBackground(SwingTools.LIGHTEST_BLUE);
        } else {
            c.setBackground(Color.WHITE);
        }
        return c;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.delegate.setValue(value);
        if (isSelected) {
            this.editorComponent.setBackground(SwingTools.LIGHTEST_BLUE);
        } else {
            this.editorComponent.setBackground(Color.WHITE);
        }
        return this.editorComponent;
    }

    @Override
    public boolean useEditorAsRenderer() {
        return this.useEditorAsRenderer;
    }

    @Override
    public void setOperator(Operator operator) {
    }

    @Override
    public boolean rendersLabel() {
        return this.rendersLabel;
    }
}

