/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class DateFormatValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -1889899793777695100L;
    private JPanel panel = new JPanel(new GridBagLayout());
    private JComboBox formatCombo;
    private AbstractButton selectButton;

    public DateFormatValueCellEditor(final ParameterTypeDateFormat type) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.weightx = 1.0;
        c.gridwidth = -1;
        this.formatCombo = new JComboBox<String>(type.getValues());
        this.formatCombo.setEditable(true);
        this.panel.add((Component)this.formatCombo, c);
        this.selectButton = new JButton(new ResourceAction(true, "dateformat.select_sample", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MetaData md;
                JPopupMenu menu = new JPopupMenu();
                if (type.getInputPort() != null && (md = type.getInputPort().getMetaData()) instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)md;
                    final ParameterTypeAttribute attributeParameterType = type.getAttributeParameterType();
                    if (attributeParameterType != null) {
                        String selectedAttributeName = type.getInputPort().getPorts().getOwner().getOperator().getParameters().getParameterOrNull(attributeParameterType.getKey());
                        AttributeMetaData selectedAttribute = emd.getAttributeByName(selectedAttributeName);
                        if (selectedAttribute != null && selectedAttribute.isNominal() && selectedAttribute.getValueSet() != null) {
                            boolean isNotMenuEmpty = false;
                            for (final String value : selectedAttribute.getValueSet()) {
                                menu.add(new JMenuItem(new AbstractAction(value){
                                    private static final long serialVersionUID = 1L;

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        DateFormatValueCellEditor.this.formatCombo.setSelectedItem(value);
                                    }
                                }));
                                isNotMenuEmpty = true;
                            }
                            if (isNotMenuEmpty) {
                                menu.show(DateFormatValueCellEditor.this.selectButton, 0, DateFormatValueCellEditor.this.selectButton.getHeight());
                            }
                            DateFormatValueCellEditor.this.selectButton.setEnabled(isNotMenuEmpty);
                        } else if (emd.getAllAttributes() != null) {
                            int j = 0;
                            boolean isNotMenuEmpty = false;
                            for (final AttributeMetaData amd : emd.getAllAttributes()) {
                                if (!amd.isNominal() || amd.getValueSet() == null) continue;
                                JMenu subMenu = new JMenu(amd.getName());
                                menu.add(subMenu);
                                int i = 0;
                                for (final String value : amd.getValueSet()) {
                                    subMenu.add(new JMenuItem(new AbstractAction(value){
                                        private static final long serialVersionUID = 1L;

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            DateFormatValueCellEditor.this.formatCombo.setSelectedItem(value);
                                            if (attributeParameterType != null && type.getInputPort() != null) {
                                                type.getInputPort().getPorts().getOwner().getOperator().getParameters().setParameter(attributeParameterType.getKey(), amd.getName());
                                            }
                                        }
                                    }));
                                    if (++i <= 21) continue;
                                    break;
                                }
                                isNotMenuEmpty = true;
                                if (++j <= 13) continue;
                                break;
                            }
                            if (isNotMenuEmpty) {
                                menu.show(DateFormatValueCellEditor.this.selectButton, 0, DateFormatValueCellEditor.this.selectButton.getHeight());
                            }
                            DateFormatValueCellEditor.this.selectButton.setEnabled(isNotMenuEmpty);
                        }
                    }
                }
            }
        });
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.selectButton.setText(null);
        this.panel.add((Component)this.selectButton, c);
        this.formatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateFormatValueCellEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public void setOperator(Operator operator) {
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.formatCombo.setSelectedItem(value);
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.formatCombo.getSelectedItem();
    }
}

