/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDatabaseTable;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.ConnectionProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DatabaseTableValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -771727412083431607L;
    private DatabaseTableComboBoxModel model = new DatabaseTableComboBoxModel();
    private JComboBox comboBox = new DatabaseTableComboBox();
    private Operator operator;
    private ParameterType type;
    private ConnectionProvider connectionProvider;

    public DatabaseTableValueCellEditor(ParameterTypeDatabaseTable type) {
        this.type = type;
        this.comboBox.setToolTipText(type.getDescription());
    }

    private String getValue() {
        String value = null;
        value = this.operator.getParameters().getParameterOrNull(this.type.getKey());
        return value;
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.model.updateModel();
        this.comboBox.setSelectedItem(value);
        return this.comboBox;
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.model.updateModel();
        this.comboBox.setSelectedItem(value);
        return this.comboBox;
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
        if (operator != null && operator instanceof ConnectionProvider) {
            this.connectionProvider = (ConnectionProvider)((Object)operator);
        }
    }

    class DatabaseTableComboBox
    extends JComboBox {
        private static final long serialVersionUID = 7641636749562465262L;

        private DatabaseTableComboBox() {
            super(DatabaseTableValueCellEditor.this.model);
            this.setEditable(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseTableValueCellEditor.this.fireEditingStopped();
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    DatabaseTableValueCellEditor.this.fireEditingStopped();
                }

                @Override
                public void focusGained(FocusEvent e) {
                    DatabaseTableValueCellEditor.this.model.updateModel();
                }
            });
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (DatabaseTableValueCellEditor.this.model.updateModel()) {
                        DatabaseTableComboBox.this.hidePopup();
                        DatabaseTableComboBox.this.showPopup();
                    }
                }
            });
        }
    }

    class DatabaseTableComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    Serializable {
        private static final long serialVersionUID = -2984664300141879731L;
        private String lastURL = null;
        private LinkedList<Object> list = new LinkedList();
        private Object selected = null;

        DatabaseTableComboBoxModel() {
        }

        public boolean updateModel() {
            ConnectionEntry entry;
            final String selected = DatabaseTableValueCellEditor.this.getValue();
            if (!(DatabaseTableValueCellEditor.this.connectionProvider == null || (entry = DatabaseTableValueCellEditor.this.connectionProvider.getConnectionEntry()) == null || this.lastURL != null && this.lastURL.equals(entry.getURL()))) {
                this.lastURL = entry.getURL();
                ProgressThread t = new ProgressThread("fetching_database_tables"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        this.getProgressListener().setTotal(100);
                        this.getProgressListener().setCompleted(10);
                        try {
                            DatabaseTableComboBoxModel.this.list.clear();
                            DatabaseHandler handler = null;
                            try {
                                handler = DatabaseHandler.getConnectedDatabaseHandler(entry);
                            }
                            catch (SQLException e1) {
                                LogService.getRoot().log(Level.WARNING, "Failed to fetch database tables: " + e1, e1);
                                SwingTools.showVerySimpleErrorMessage("Retrieval of table names failed", new Object[0]);
                                this.getProgressListener().complete();
                                return;
                            }
                            this.getProgressListener().setCompleted(20);
                            if (handler != null) {
                                try {
                                    Map<String, List<ColumnIdentifier>> tableMap = handler.getAllTableMetaData(this.getProgressListener(), 20, 90, false);
                                    DatabaseTableComboBoxModel.this.list.addAll(tableMap.keySet());
                                    this.getProgressListener().setCompleted(90);
                                }
                                catch (SQLException e) {
                                    LogService.getRoot().log(Level.WARNING, "Failed to fetch database tables: " + e, e);
                                    SwingTools.showVerySimpleErrorMessage("Retrieval of table names failed.", new Object[0]);
                                    this.getProgressListener().complete();
                                    return;
                                }
                                try {
                                    handler.disconnect();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                            }
                            if (DatabaseTableComboBoxModel.this.getSelectedItem() == null) {
                                if (DatabaseTableValueCellEditor.this.model.getSize() == 0) {
                                    DatabaseTableComboBoxModel.this.setSelectedItem(null);
                                } else if (selected != null) {
                                    DatabaseTableComboBoxModel.this.setSelectedItem(selected);
                                } else if (DatabaseTableValueCellEditor.this.model.getSize() > 0) {
                                    DatabaseTableComboBoxModel.this.setSelectedItem(DatabaseTableValueCellEditor.this.model.getElementAt(0));
                                }
                            }
                            DatabaseTableComboBoxModel.this.fireContentsChanged(this, 0, DatabaseTableComboBoxModel.this.list.size() - 1);
                        }
                        finally {
                            this.getProgressListener().complete();
                        }
                    }
                };
                t.start();
                return true;
            }
            return false;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selected != null && !this.selected.equals(object) || this.selected == null && object != null) {
                this.selected = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getElementAt(int index) {
            if (index >= 0 && index < this.list.size()) {
                return this.list.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.list.size();
        }
    }
}

