/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ManageDatabaseConnectionsDialog;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeDatabaseConnection;
import com.rapidminer.tools.jdbc.connection.DatabaseConnectionService;
import com.rapidminer.tools.jdbc.connection.FieldConnectionEntry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;

public class DatabaseConnectionValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -771727412083431607L;
    private DatabaseConnectionComboBoxModel model = new DatabaseConnectionComboBoxModel();
    private JPanel panel = new JPanel();
    private JComboBox comboBox = new JComboBox(this.model);

    public DatabaseConnectionValueCellEditor(ParameterTypeDatabaseConnection type) {
        this.panel.setLayout(new GridBagLayout());
        this.panel.setToolTipText(type.getDescription());
        this.comboBox.setToolTipText(type.getDescription());
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseConnectionValueCellEditor.this.fireEditingStopped();
            }
        });
        this.comboBox.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                DatabaseConnectionValueCellEditor.this.fireEditingStopped();
            }

            @Override
            public void focusGained(FocusEvent e) {
                DatabaseConnectionValueCellEditor.this.model.updateModel();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.panel.add((Component)this.comboBox, c);
        JButton button = new JButton(new ResourceAction(true, "manage_db_connections", new Object[0]){
            private static final long serialVersionUID = 3989811306286704326L;
            {
                this.putValue("Name", "");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                class SetDatabaseConnectionDialog
                extends ManageDatabaseConnectionsDialog {
                    private static final long serialVersionUID = 2306881477330192804L;

                    @Override
                    protected void ok() {
                        FieldConnectionEntry entry = this.checkFields(true);
                        if (entry != null) {
                            boolean existent = false;
                            for (FieldConnectionEntry listEntry : DatabaseConnectionService.getConnectionEntries()) {
                                if (!listEntry.getName().equals(entry.getName())) continue;
                                existent = true;
                                break;
                            }
                            if (!existent) {
                                if (SwingTools.showConfirmDialog("save", 0, entry.getName()) == 0) {
                                    DatabaseConnectionService.addConnectionEntry(entry);
                                } else {
                                    DatabaseConnectionValueCellEditor.this.fireEditingCanceled();
                                    return;
                                }
                            }
                            DatabaseConnectionValueCellEditor.this.model.updateModel();
                            DatabaseConnectionValueCellEditor.this.model.setSelectedItem(entry.getName());
                            DatabaseConnectionValueCellEditor.this.fireEditingStopped();
                            super.ok();
                        }
                    }
                }
                SetDatabaseConnectionDialog dialog = new SetDatabaseConnectionDialog();
                dialog.setVisible(true);
                DatabaseConnectionValueCellEditor.this.model.updateModel();
            }
        });
        button.setMargin(new Insets(0, 0, 0, 0));
        c.weightx = 0.0;
        this.panel.add((Component)button, c);
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.model.updateModel();
        this.comboBox.setSelectedItem(value);
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.model.updateModel();
        this.comboBox.setSelectedItem(value);
        return this.panel;
    }

    @Override
    public void setOperator(Operator operator) {
    }

    class DatabaseConnectionComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -2984664300141879731L;

        DatabaseConnectionComboBoxModel() {
        }

        public void updateModel() {
            Object selected = this.getSelectedItem();
            this.removeAllElements();
            for (FieldConnectionEntry entry : DatabaseConnectionService.getConnectionEntries()) {
                this.addElement(entry.getName());
            }
            if (DatabaseConnectionValueCellEditor.this.model.getSize() == 0) {
                this.setSelectedItem(null);
            } else if (selected != null) {
                this.setSelectedItem(selected);
            } else if (DatabaseConnectionValueCellEditor.this.model.getSize() > 0) {
                this.setSelectedItem(DatabaseConnectionValueCellEditor.this.model.getElementAt(0));
            }
        }
    }
}

