/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.components.ColorIcon;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JTable;

public class ColorValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -7069543356398085334L;
    private transient ParameterTypeColor type;
    private JButton button;

    public ColorValueCellEditor(final ParameterTypeColor type) {
        this.type = type;
        this.button = new JButton("Choose Color...");
        this.button.setToolTipText(type.getDescription());
        this.button.setIconTextGap(6);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(RapidMinerGUI.getMainFrame(), "Choose Color for " + type.getKey(), ((ColorIcon)ColorValueCellEditor.this.button.getIcon()).getColor());
                if (newColor != null) {
                    ColorValueCellEditor.this.setEditorColor(newColor);
                }
                ColorValueCellEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public void setOperator(Operator operator) {
    }

    public void setEditorColor(Color color) {
        this.button.setIcon(new ColorIcon(color));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        if (value == null) {
            this.setEditorColor(this.transformString2Color((String)this.type.getDefaultValue()));
        } else {
            this.setEditorColor(this.transformString2Color((String)value));
        }
        return this.button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        Color color = ((ColorIcon)this.button.getIcon()).getColor();
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    private Color transformString2Color(String value) {
        String[] colors = value.split(",");
        Color color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        return color;
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }
}

