/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.AttributesPropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.UndefinedParameterError;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class AttributesValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -2387465714767785072L;
    private String attributeListString = "";
    private final JButton button;
    private Operator operator;

    public AttributesValueCellEditor(final ParameterTypeAttributes type) {
        this.button = new JButton(new ResourceAction(true, "attributes", new Object[0]){
            private static final long serialVersionUID = -4890375754223285831L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedList<String> preSelectedAttributeNames = new LinkedList<String>();
                String combinedNames = null;
                try {
                    combinedNames = AttributesValueCellEditor.this.operator.getParameter(type.getKey());
                }
                catch (UndefinedParameterError er) {
                    // empty catch block
                }
                if (combinedNames != null) {
                    for (String attributeName : combinedNames.split("\\|")) {
                        preSelectedAttributeNames.add(attributeName);
                    }
                }
                AttributesPropertyDialog dialog = new AttributesPropertyDialog(type, preSelectedAttributeNames);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    StringBuilder builder = new StringBuilder();
                    boolean first = true;
                    Collection<String> attributeNames = dialog.getSelectedAttributeNames();
                    for (String attributeName : attributeNames) {
                        if (!first) {
                            builder.append("|");
                        }
                        builder.append(attributeName);
                        first = false;
                    }
                    AttributesValueCellEditor.this.attributeListString = builder.toString();
                    AttributesValueCellEditor.this.fireEditingStopped();
                } else {
                    AttributesValueCellEditor.this.fireEditingCanceled();
                }
            }
        });
        this.button.setMargin(new Insets(0, 0, 0, 0));
    }

    @Override
    public Object getCellEditorValue() {
        return this.attributeListString;
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public boolean useEditorAsRenderer() {
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.button;
    }
}

