/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.celleditors.value.AttributeComboBox;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeAttribute;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

public class AttributeValueCellEditor
extends DefaultCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -1889899793777695100L;

    public AttributeValueCellEditor(ParameterTypeAttribute type) {
        super(new AttributeComboBox(type));
        final JComboBox comboBox = (JComboBox)this.editorComponent;
        final JTextComponent textField = (JTextComponent)comboBox.getEditor().getEditorComponent();
        comboBox.removeItemListener(this.delegate);
        comboBox.setEditable(true);
        comboBox.removeActionListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            private static final long serialVersionUID = -5592150438626222295L;

            @Override
            public void setValue(Object x) {
                if (x == null) {
                    super.setValue(null);
                    comboBox.setSelectedItem(null);
                } else {
                    String value = x.toString();
                    super.setValue(x);
                    comboBox.setSelectedItem(value);
                    if (value != null) {
                        textField.setText(value.toString());
                    } else {
                        textField.setText("");
                    }
                }
            }

            @Override
            public Object getCellEditorValue() {
                String selected = textField.getText();
                if (selected != null && selected.trim().length() == 0) {
                    selected = null;
                }
                return selected;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("comboBoxEdited")) {
                    super.actionPerformed(event);
                }
            }
        };
        comboBox.addActionListener(this.delegate);
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                comboBox.actionPerformed(new ActionEvent(comboBox, 12, "comboBoxEdited"));
                super.focusLost(e);
            }
        });
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && !comboBox.isPopupVisible()) {
                    comboBox.actionPerformed(new ActionEvent(comboBox, 12, "comboBoxEdited"));
                    e.consume();
                }
            }
        });
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public void setOperator(Operator operator) {
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component editorComponent = this.getTableCellEditorComponent(table, value, isSelected, row, column);
        return editorComponent;
    }
}

