/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.tools.autocomplete.AutoCompleteComboBoxAddition;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.MetaDataChangeListener;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterTypeAttribute;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class AttributeComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private AttributeComboBoxModel model = (AttributeComboBoxModel)this.getModel();

    public AttributeComboBox(ParameterTypeAttribute type) {
        super(new AttributeComboBoxModel(type));
        AutoCompleteComboBoxAddition autoCompleteCBA = new AutoCompleteComboBoxAddition(this);
        autoCompleteCBA.setCaseSensitive(true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.model.registerListener();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.model.unregisterListener();
    }

    private static class AttributeComboBoxModel
    extends DefaultComboBoxModel
    implements MetaDataChangeListener {
        private static final long serialVersionUID = 1L;
        private ParameterTypeAttribute attributeType;
        private Vector<String> attributes = new Vector();

        public AttributeComboBoxModel(ParameterTypeAttribute attributeType) {
            this.attributeType = attributeType;
            InputPort inputPort = attributeType.getInputPort();
            if (inputPort != null && inputPort.getMetaData() != null) {
                this.informMetaDataChanged(inputPort.getMetaData());
            }
        }

        @Override
        public int getSize() {
            return this.attributes.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.attributes.get(index);
        }

        protected void registerListener() {
            InputPort inputPort = this.attributeType.getInputPort();
            if (inputPort != null) {
                inputPort.registerMetaDataChangeListener(this);
            }
        }

        protected void unregisterListener() {
            InputPort inputPort = this.attributeType.getInputPort();
            if (inputPort != null) {
                inputPort.removeMetaDataChangeListener(this);
            }
        }

        @Override
        public void informMetaDataChanged(MetaData newMetadata) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AttributeComboBoxModel.this.attributes = AttributeComboBoxModel.this.attributeType.getAttributeNames();
                    AttributeComboBoxModel.this.fireContentsChanged(0, 0, AttributeComboBoxModel.this.attributes.size());
                }
            });
        }
    }
}

