/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.Process;
import com.rapidminer.gui.properties.DefaultPropertyTable;
import com.rapidminer.gui.templates.OperatorParameterPair;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class WizardPropertyTable
extends DefaultPropertyTable {
    private static final long serialVersionUID = 1510360561085238281L;
    private transient Operator[] operators;
    private transient ParameterType[] parameterTypes;

    public WizardPropertyTable() {
        this.setProcess(null, null);
    }

    public void setProcess(Process process, Collection<OperatorParameterPair> parameters) {
        if (process == null) {
            parameters = new LinkedList<OperatorParameterPair>();
        }
        this.updateTableData(parameters.size());
        this.operators = new Operator[parameters.size()];
        this.parameterTypes = new ParameterType[parameters.size()];
        Iterator<OperatorParameterPair> i = parameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            OperatorParameterPair parameter = i.next();
            this.operators[j] = process.getOperator(parameter.getOperator());
            this.parameterTypes[j] = WizardPropertyTable.getParameterType(this.operators[j], parameter.getParameter());
            this.getModel().setValueAt(this.operators[j].getName() + "." + this.parameterTypes[j].getKey(), j, 0);
            Object value = this.parameterTypes[j].getDefaultValue();
            try {
                value = this.operators[j].getParameters().getParameter(this.parameterTypes[j].getKey());
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            this.getModel().setValueAt(value, j, 1);
            ++j;
        }
        this.updateEditorsAndRenderers();
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                WizardPropertyTable.this.setValue(e.getFirstRow(), WizardPropertyTable.this.getModel().getValueAt(e.getFirstRow(), 1));
            }
        });
    }

    private static ParameterType getParameterType(Operator operator, String key) {
        for (ParameterType type : operator.getParameters().getParameterTypes()) {
            if (!type.getKey().equals(key)) continue;
            return type;
        }
        return null;
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    @Override
    public Operator getOperator(int row) {
        return this.operators[row];
    }
}

