/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.properties.SettingsPropertyPanel;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.ParameterService;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class SettingsTabs
extends ExtendedJTabbedPane {
    private static final long serialVersionUID = -229446448782516589L;
    private final List<SettingsPropertyPanel> tables = new LinkedList<SettingsPropertyPanel>();

    public SettingsTabs() {
        this(null);
    }

    public SettingsTabs(String initialSelectedTab) {
        Set<ParameterType> allProperties = RapidMiner.getRapidMinerProperties();
        TreeMap<String, LinkedList<ParameterType>> groups = new TreeMap<String, LinkedList<ParameterType>>();
        for (ParameterType type : allProperties) {
            String key = type.getKey();
            String[] parts = key.split("\\.");
            String group = "rapidminer".equals(parts[0]) ? parts[1] : "system";
            LinkedList<ParameterType> list = (LinkedList<ParameterType>)groups.get(group);
            if (list == null) {
                list = new LinkedList<ParameterType>();
                groups.put(group, list);
            }
            list.add(type);
        }
        for (Map.Entry e : groups.entrySet()) {
            String group = (String)e.getKey();
            if (initialSelectedTab != null && !initialSelectedTab.equals(group)) continue;
            List groupList = (List)e.getValue();
            SettingsPropertyPanel table = new SettingsPropertyPanel(groupList);
            this.tables.add(table);
            String name = new String(new char[]{group.charAt(0)}).toUpperCase() + group.substring(1, group.length());
            ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(table);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setPreferredSize(new Dimension(600, 300));
            this.addTab(name, scrollPane);
        }
    }

    public void applyProperties() {
        Iterator<SettingsPropertyPanel> i = this.tables.iterator();
        while (i.hasNext()) {
            i.next().applyProperties();
        }
    }

    public void save() throws IOException {
        this.applyProperties();
        Properties props = new Properties();
        Iterator<SettingsPropertyPanel> i = this.tables.iterator();
        while (i.hasNext()) {
            i.next().applyProperties(props);
        }
        ParameterService.writeProperties(props, ParameterService.getMainUserConfigFile());
    }
}

