/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Properties;

public class SettingsPropertyPanel
extends PropertyPanel {
    private static final long serialVersionUID = 313811558626370370L;
    private final Collection<ParameterType> propertyTypes;
    private final Properties properties;

    public SettingsPropertyPanel(Collection<ParameterType> allProperties) {
        this.propertyTypes = allProperties;
        this.properties = new Properties(System.getProperties());
        this.setupComponents();
    }

    @Override
    protected Collection<ParameterType> getProperties() {
        return this.propertyTypes;
    }

    @Override
    protected String getValue(ParameterType type) {
        String value = this.properties.getProperty(type.getKey());
        if (value == null) {
            return null;
        }
        return type.transformNewValue(value);
    }

    @Override
    protected void setValue(Operator operator, ParameterType type, String value) {
        this.properties.put(type.getKey(), value);
    }

    public void applyProperties() {
        this.applyProperties(System.getProperties());
    }

    public void applyProperties(Properties properties) {
        for (ParameterType type : this.propertyTypes) {
            String value = this.getValue(type);
            if (value != null) {
                properties.setProperty(type.getKey(), value);
                continue;
            }
            properties.remove(type.getKey());
        }
    }

    public void writeProperties(PrintWriter out) throws IOException {
        for (ParameterType type : this.propertyTypes) {
            String value = this.getValue(type);
            if (value == null) continue;
            System.setProperty(type.getKey(), value);
            out.println(type.getKey() + " = " + value);
        }
    }

    @Override
    protected Operator getOperator() {
        return null;
    }
}

