/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.SettingsChangeListener;
import com.rapidminer.gui.properties.SettingsTabs;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.ParameterService;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SettingsDialog
extends ButtonDialog {
    private static final long serialVersionUID = 6665295638614289994L;
    private final SettingsTabs tabs;
    private final List<SettingsChangeListener> listeners = new LinkedList<SettingsChangeListener>();

    public SettingsDialog() {
        this((String)null);
    }

    public SettingsDialog(String initialSelectedTab) {
        super("settings", true, new Object[0]);
        this.tabs = new SettingsTabs(initialSelectedTab);
        LinkedList<AbstractButton> buttons = new LinkedList<AbstractButton>();
        buttons.add(new JButton(new ResourceAction("settings_apply", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.tabs.applyProperties();
                SettingsDialog.this.fireSettingsChanged();
                SettingsDialog.this.setConfirmed(true);
                SettingsDialog.this.dispose();
            }
        }));
        buttons.add(new JButton(new ResourceAction("settings_save", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SettingsDialog.this.tabs.save();
                    SettingsDialog.this.fireSettingsChanged();
                    SettingsDialog.this.setConfirmed(true);
                    SettingsDialog.this.dispose();
                }
                catch (IOException ioe) {
                    SwingTools.showSimpleErrorMessage("cannot_save_properties", (Throwable)ioe, new Object[0]);
                }
            }
        }));
        buttons.add(this.makeCancelButton());
        this.layoutDefault((JComponent)this.tabs, 1, buttons);
    }

    @Override
    public String getInfoText() {
        return I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.settings.message", ParameterService.getUserConfigFile("rapidminerrc." + System.getProperty("os.name")));
    }

    public void addSettingsChangedListener(SettingsChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeSettingsChangedListener(SettingsChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSettingsChanged() {
        Iterator<SettingsChangeListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().settingsChanged(System.getProperties());
        }
    }
}

