/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyDialog;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class RegexpPropertyDialog
extends PropertyDialog {
    private static final long serialVersionUID = 5396725165122306231L;
    private static String[][] regexpConstructs = new String[][]{{".", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.any_character", new Object[0])}, {"[]", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.bracket_expression", new Object[0])}, {"[^]", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.not_bracket_expression", new Object[0])}, {"()", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.capturing_group", new Object[0])}, {"?", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.zero_one_quantifier", new Object[0])}, {"*", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.zero_more_quantifier", new Object[0])}, {"+", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.one_more_quantifier", new Object[0])}, {"{n}", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.exact_quantifier", new Object[0])}, {"{min,}", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.min_quantifier", new Object[0])}, {"{min,max}", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.min_max_quantifier", new Object[0])}, {"|", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.constructs.disjunction", new Object[0])}};
    private static int[] regexpConstructInsertionCaretAdjustment = new int[]{0, -1, -1, -1, 0, 0, 0, -1, -2, -1, -5, 0};
    private static int[][] regexpConstructInsertionSelectionIndices = new int[][]{{1, 1}, {1, 1}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 2}, {1, 4}, {1, 8}, {1, 1}};
    private static boolean[] regexpConstructInsertionEncloseSelected = new boolean[]{false, true, true, true, false, false, false, false, false, false, false};
    private static String[][] regexpShortcuts = new String[][]{{".*", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.arbitrary", new Object[0])}, {"[a-zA-Z]", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.letter", new Object[0])}, {"[a-z]", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.lowercase_letter", new Object[0])}, {"[A-Z]", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.uppercase_letter", new Object[0])}, {"[0-9]", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.digit", new Object[0])}, {"\\w", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.word", new Object[0])}, {"\\W", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.non_word", new Object[0])}, {"\\s", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.whitespace", new Object[0])}, {"\\S", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.non_whitespace", new Object[0])}, {"[-!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]_`{|}~]", I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.shortcuts.punctuation", new Object[0])}};
    private static final String ERROR_MESSAGE = I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.error.label", new Object[0]);
    private static final Icon ERROR_ICON = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.error.icon", new Object[0]));
    private static final String NO_ERROR_MESSAGE = I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.no_error.label", new Object[0]);
    private static final Icon NO_ERROR_ICON = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.no_error.icon", new Object[0]));
    private final JTextField regexpTextField;
    private JList itemShortcutsList;
    private DefaultListModel matchedItemsListModel;
    private final Collection<String> items;
    private boolean supportsItems = false;
    private final JLabel errorMessage;
    private JButton okButton;

    public RegexpPropertyDialog(ParameterTypeRegexp type, String predefinedRegexp, Operator operator) {
        super(type, "regexp");
        this.items = type.getPreviewList();
        this.supportsItems = this.items != null;
        JPanel panel = new JPanel(RegexpPropertyDialog.createGridLayout(1, this.supportsItems ? 2 : 1));
        this.regexpTextField = new JTextField(predefinedRegexp);
        this.regexpTextField.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.tip", new Object[0]));
        this.regexpTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                RegexpPropertyDialog.this.fireRegularExpressionUpdated();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.regexpTextField.requestFocus();
        final TableModel regexpConstructTableModel = new TableModel(){
            private static final long serialVersionUID = 3081581916411341948L;

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.constructs_table.construct_header", new Object[0]);
                    }
                    case 1: {
                        return I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.constructs_table.description_header", new Object[0]);
                    }
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return regexpConstructs.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return regexpConstructs[rowIndex][columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
            }
        };
        final JTable regexpConstructTable = new JTable(regexpConstructTableModel);
        regexpConstructTable.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.constructs_table.tip", new Object[0]));
        regexpConstructTable.setCellSelectionEnabled(true);
        regexpConstructTable.setSelectionMode(0);
        regexpConstructTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = regexpConstructTable.getSelectedRow();
                    String text = RegexpPropertyDialog.this.regexpTextField.getText();
                    String insertionString = regexpConstructTableModel.getValueAt(row, 0).toString();
                    if (regexpConstructInsertionEncloseSelected[row] && RegexpPropertyDialog.this.regexpTextField.getSelectedText() != null) {
                        int selectionStart = RegexpPropertyDialog.this.regexpTextField.getSelectionStart();
                        int selectionEnd = RegexpPropertyDialog.this.regexpTextField.getSelectionEnd();
                        String newText = text.substring(0, selectionStart) + insertionString.substring(0, regexpConstructInsertionSelectionIndices[row][0]) + text.substring(selectionStart, selectionEnd) + insertionString.substring(regexpConstructInsertionSelectionIndices[row][0], insertionString.length()) + text.substring(selectionEnd, text.length());
                        RegexpPropertyDialog.this.regexpTextField.setText(newText);
                        RegexpPropertyDialog.this.regexpTextField.setCaretPosition(selectionEnd - regexpConstructInsertionCaretAdjustment[row]);
                        RegexpPropertyDialog.this.regexpTextField.setSelectionStart(selectionStart + regexpConstructInsertionSelectionIndices[row][0]);
                        RegexpPropertyDialog.this.regexpTextField.setSelectionEnd(selectionEnd + regexpConstructInsertionSelectionIndices[row][1]);
                        RegexpPropertyDialog.this.regexpTextField.requestFocus();
                    } else {
                        int cursorPosition = RegexpPropertyDialog.this.regexpTextField.getCaretPosition();
                        String newText = text.substring(0, cursorPosition) + insertionString + (cursorPosition < text.length() ? text.substring(cursorPosition) : "");
                        RegexpPropertyDialog.this.regexpTextField.setText(newText);
                        RegexpPropertyDialog.this.regexpTextField.setCaretPosition(cursorPosition + insertionString.length() + regexpConstructInsertionCaretAdjustment[row]);
                        RegexpPropertyDialog.this.regexpTextField.setSelectionStart(cursorPosition + regexpConstructInsertionSelectionIndices[row][0]);
                        RegexpPropertyDialog.this.regexpTextField.setSelectionEnd(cursorPosition + regexpConstructInsertionSelectionIndices[row][1]);
                        RegexpPropertyDialog.this.regexpTextField.requestFocus();
                    }
                    RegexpPropertyDialog.this.fireRegularExpressionUpdated();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        regexpConstructTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -8024658831923934442L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (column == 1) {
                    Component c = super.getTableCellRendererComponent(table, value, false, false, row, column);
                    c.setFont(c.getFont().deriveFont(2));
                    return c;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        for (int i = 0; i < regexpConstructTable.getColumnCount(); ++i) {
            TableColumn column = regexpConstructTable.getColumn(regexpConstructTable.getModel().getColumnName(i));
            int width = 0;
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = regexpConstructTable.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(regexpConstructTable, column.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < regexpConstructTable.getRowCount(); ++r) {
                renderer = regexpConstructTable.getCellRenderer(r, i);
                comp = renderer.getTableCellRendererComponent(regexpConstructTable, regexpConstructTable.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(width);
        }
        JScrollPane regexConstructTablePane = new JScrollPane(regexpConstructTable);
        final TableModel regexpShortcutsTableModel = new TableModel(){
            private static final long serialVersionUID = 3081581916411341948L;

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.shortcuts_table.shortcuts_header", new Object[0]);
                    }
                    case 1: {
                        return I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.shortcuts_table.description_header", new Object[0]);
                    }
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return regexpShortcuts.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return regexpShortcuts[rowIndex][columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
            }
        };
        final JTable regexpShortcutsTable = new JTable(regexpShortcutsTableModel);
        regexpShortcutsTable.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.shortcuts_table.tip", new Object[0]));
        regexpShortcutsTable.setCellSelectionEnabled(true);
        regexpShortcutsTable.setSelectionMode(0);
        regexpShortcutsTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String text = RegexpPropertyDialog.this.regexpTextField.getText();
                    int cursorPosition = RegexpPropertyDialog.this.regexpTextField.getCaretPosition();
                    String insertionString = regexpShortcutsTableModel.getValueAt(regexpShortcutsTable.getSelectedRow(), 0).toString();
                    String newText = text.substring(0, cursorPosition) + insertionString + (cursorPosition < text.length() ? text.substring(cursorPosition) : "");
                    RegexpPropertyDialog.this.regexpTextField.setText(newText);
                    RegexpPropertyDialog.this.regexpTextField.setCaretPosition(cursorPosition + insertionString.length());
                    RegexpPropertyDialog.this.regexpTextField.requestFocus();
                    RegexpPropertyDialog.this.fireRegularExpressionUpdated();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        regexpShortcutsTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -8024658831923934442L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (column == 1) {
                    Component c = super.getTableCellRendererComponent(table, value, false, false, row, column);
                    c.setFont(c.getFont().deriveFont(2));
                    return c;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        for (int i = 0; i < regexpShortcutsTable.getColumnCount(); ++i) {
            TableColumn column = regexpShortcutsTable.getColumn(regexpShortcutsTable.getModel().getColumnName(i));
            int width = 0;
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = regexpShortcutsTable.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(regexpShortcutsTable, column.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < regexpShortcutsTable.getRowCount(); ++r) {
                renderer = regexpShortcutsTable.getCellRenderer(r, i);
                comp = renderer.getTableCellRendererComponent(regexpShortcutsTable, regexpShortcutsTable.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(width);
        }
        JScrollPane regexShortcutsTablePane = new JScrollPane(regexpShortcutsTable);
        JPanel regexpPanel = new JPanel(new GridBagLayout());
        regexpPanel.setBorder(RegexpPropertyDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.border", new Object[0])));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 4, 4, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 1;
        regexpPanel.add((Component)this.regexpTextField, c);
        c.insets = new Insets(4, 0, 4, 4);
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 2;
        JButton clearRegexpTextFieldButton = new JButton(SwingTools.createIcon("16/delete2.png"));
        clearRegexpTextFieldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegexpPropertyDialog.this.regexpTextField.setText("");
                RegexpPropertyDialog.this.fireRegularExpressionUpdated();
                RegexpPropertyDialog.this.regexpTextField.requestFocusInWindow();
            }
        });
        regexpPanel.add((Component)clearRegexpTextFieldButton, c);
        this.errorMessage = new JLabel(NO_ERROR_MESSAGE, NO_ERROR_ICON, 2);
        this.errorMessage.setFocusable(false);
        c.insets = new Insets(4, 8, 4, 4);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        regexpPanel.add((Component)this.errorMessage, c);
        c.insets = new Insets(20, 4, 4, 4);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        JTabbedPane tips = new JTabbedPane();
        tips.add(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.constructs_table.title", new Object[0]), regexConstructTablePane);
        tips.add(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.regular_expression.shortcuts_table.title", new Object[0]), regexShortcutsTablePane);
        regexpPanel.add((Component)tips, c);
        panel.add(regexpPanel, 0, 0);
        if (this.supportsItems) {
            this.itemShortcutsList = new JList<Object>(this.items.toArray());
            this.itemShortcutsList.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.item_shortcuts.tip", new Object[0]));
            this.itemShortcutsList.setSelectionMode(0);
            this.itemShortcutsList.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        String text = RegexpPropertyDialog.this.regexpTextField.getText();
                        int cursorPosition = RegexpPropertyDialog.this.regexpTextField.getCaretPosition();
                        int index = RegexpPropertyDialog.this.itemShortcutsList.getSelectedIndex();
                        if (index > -1 && index < RegexpPropertyDialog.this.itemShortcutsList.getModel().getSize()) {
                            String insertionString = RegexpPropertyDialog.this.itemShortcutsList.getModel().getElementAt(index).toString();
                            String newText = text.substring(0, cursorPosition) + insertionString + (cursorPosition < text.length() ? text.substring(cursorPosition) : "");
                            RegexpPropertyDialog.this.regexpTextField.setText(newText);
                            RegexpPropertyDialog.this.regexpTextField.setCaretPosition(cursorPosition + insertionString.length());
                            RegexpPropertyDialog.this.regexpTextField.requestFocus();
                            RegexpPropertyDialog.this.fireRegularExpressionUpdated();
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            JScrollPane itemShortcutsPane = new JScrollPane(this.itemShortcutsList);
            itemShortcutsPane.setBorder(RegexpPropertyDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.item_shortcuts.border", new Object[0])));
            this.matchedItemsListModel = new DefaultListModel();
            JList<Object> matchedItemsList = new JList<Object>(this.matchedItemsListModel);
            matchedItemsList.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.matched_items.tip", new Object[0]));
            matchedItemsList.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -5795848004756768378L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return super.getListCellRendererComponent((JList<?>)list, value, index, false, false);
                }
            });
            JScrollPane matchedItemsPanel = new JScrollPane(matchedItemsList);
            matchedItemsPanel.setBorder(RegexpPropertyDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.parameter.regexp.matched_items.border", new Object[0])));
            JPanel itemPanel = new JPanel(RegexpPropertyDialog.createGridLayout(1, 2));
            itemPanel.add(itemShortcutsPane, 0, 0);
            itemPanel.add(matchedItemsPanel, 0, 1);
            panel.add(itemPanel, 0, 1);
        }
        this.okButton = this.makeOkButton();
        this.fireRegularExpressionUpdated();
        this.layoutDefault((JComponent)panel, this.supportsItems ? 1 : 2, this.okButton, this.makeCancelButton());
    }

    private void fireRegularExpressionUpdated() {
        boolean regularExpressionValid = false;
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(this.regexpTextField.getText());
            regularExpressionValid = true;
        }
        catch (PatternSyntaxException e) {
            regularExpressionValid = false;
        }
        if (this.supportsItems) {
            this.matchedItemsListModel.clear();
            if (regularExpressionValid && pattern != null) {
                for (String previewString : this.items) {
                    if (!pattern.matcher(previewString).matches()) continue;
                    this.matchedItemsListModel.addElement(previewString);
                }
            }
        }
        if (regularExpressionValid) {
            this.errorMessage.setText(NO_ERROR_MESSAGE);
            this.errorMessage.setIcon(NO_ERROR_ICON);
            this.okButton.setEnabled(true);
        } else {
            this.errorMessage.setText(ERROR_MESSAGE);
            this.errorMessage.setIcon(ERROR_ICON);
            this.okButton.setEnabled(false);
        }
    }

    public String getRegexp() {
        return this.regexpTextField.getText();
    }
}

