/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyTableParameterChangeListener;
import com.rapidminer.gui.properties.celleditors.key.DefaultPropertyKeyRenderer;
import com.rapidminer.gui.properties.celleditors.key.DelegationKeyCellEditor;
import com.rapidminer.gui.properties.celleditors.key.ParameterValueKeyCellEditor;
import com.rapidminer.gui.properties.celleditors.key.PropertyKeyCellEditor;
import com.rapidminer.gui.properties.celleditors.value.DefaultPropertyValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeParameterValue;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.LogService;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class PropertyTable
extends ExtendedJTable {
    private static final long serialVersionUID = -8510884721529372231L;
    private static Map<Class<? extends ParameterType>, Class<? extends PropertyValueCellEditor>> knownValueEditors = new HashMap<Class<? extends ParameterType>, Class<? extends PropertyValueCellEditor>>();
    private static Map<Class<? extends ParameterType>, Class<? extends PropertyKeyCellEditor>> knownKeyEditors = new HashMap<Class<? extends ParameterType>, Class<? extends PropertyKeyCellEditor>>();
    private DefaultTableModel model;
    private final List<PropertyValueCellEditor> valueEditors = new ArrayList<PropertyValueCellEditor>();
    private final List<PropertyKeyCellEditor> keyEditors = new ArrayList<PropertyKeyCellEditor>();
    private final List<String> toolTips = new ArrayList<String>();
    private String[] columnNames = new String[]{"Key", "Value"};
    private final PropertyTableParameterChangeListener changeListener = new PropertyTableParameterChangeListener(this);

    public PropertyTable() {
        this(new String[]{"Key", "Value"});
    }

    public PropertyTable(String[] columnNames) {
        super(null, false, false);
        this.columnNames = columnNames;
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setRowHeight(28);
        this.setShowPopupMenu(false);
    }

    public abstract ParameterType getParameterType(int var1);

    public ParameterType getKeyParameterType(int row) {
        return this.getParameterType(row);
    }

    public abstract Operator getOperator(int var1);

    public DefaultTableModel getDefaultModel() {
        return this.model;
    }

    protected void updateEditorsAndRenderers() {
        this.valueEditors.clear();
        this.keyEditors.clear();
        this.toolTips.clear();
        int numberOfRows = this.getModel().getRowCount();
        for (int i = 0; i < numberOfRows; ++i) {
            String range;
            ParameterType type = this.getParameterType(i);
            this.valueEditors.add(PropertyTable.createPropertyValueCellEditor(type, this.getOperator(i)));
            ParameterType keyType = this.getKeyParameterType(i);
            PropertyKeyCellEditor keyEditor = PropertyTable.createPropertyKeyCellEditor(this, keyType, this.getOperator(i), this.changeListener);
            this.keyEditors.add(keyEditor);
            StringBuffer toolTip = new StringBuffer(type.getDescription());
            if (!(type instanceof ParameterTypeCategory) && !(type instanceof ParameterTypeStringCategory) && (range = type.getRange()) != null && range.trim().length() > 0) {
                toolTip.append(" (");
                toolTip.append(type.getRange());
                toolTip.append(")");
            }
            this.toolTips.add(SwingTools.transformToolTipText(toolTip.toString()));
        }
    }

    public int getNumberOfKeyEditors() {
        return this.keyEditors.size();
    }

    protected PropertyKeyCellEditor getKeyEditor(int index) {
        if (this.keyEditors.size() == 0) {
            return null;
        }
        return this.keyEditors.get(index);
    }

    protected void updateTableData(int rows) {
        this.setModel(new DefaultTableModel(this.columnNames, rows));
    }

    public void setModel(DefaultTableModel model) {
        this.model = model;
        super.setModel(model);
    }

    public int getNumberOfValueEditors() {
        return this.valueEditors.size();
    }

    public PropertyValueCellEditor getValueEditor(int index) {
        return this.valueEditors.get(index);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 1) {
            return this.valueEditors.get(row);
        }
        TableCellRenderer renderer = this.keyEditors.get(row);
        if (renderer instanceof TableCellEditor) {
            return (TableCellEditor)((Object)renderer);
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 1) {
            PropertyValueCellEditor editor = this.valueEditors.get(row);
            if (!editor.useEditorAsRenderer()) {
                return super.getCellRenderer(row, column);
            }
            return editor;
        }
        if (this.keyEditors.size() == 0) {
            return null;
        }
        return this.keyEditors.get(row);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        TableCellEditor editor = this.getCellEditor(row, column);
        if (editor != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, row, column);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(row, column, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.editorComp.repaint();
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingColumn(column);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    private String getToolTipText(int row) {
        if (row >= 0 && row < this.toolTips.size()) {
            return this.toolTips.get(row);
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        return this.getToolTipText(row);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = PropertyTable.this.convertColumnIndexToModel(index);
                if (realColumnIndex == 0) {
                    return "The names of the parameters.";
                }
                return "The values of the parameters.";
            }
        };
    }

    public static void registerPropertyValueCellEditor(Class<? extends ParameterType> typeClass, Class<? extends PropertyValueCellEditor> editor) {
        knownValueEditors.put(typeClass, editor);
    }

    public static void registerPropertyKeyCellEditor(Class<? extends ParameterType> typeClass, Class<? extends PropertyKeyCellEditor> editor) {
        knownKeyEditors.put(typeClass, editor);
    }

    public static PropertyValueCellEditor createPropertyValueCellEditor(ParameterType type, Operator operator) {
        Class<? extends PropertyValueCellEditor> clazz = knownValueEditors.get(type.getClass());
        Class<?> usedClass = type.getClass();
        if (clazz == null) {
            while (clazz == null && ParameterType.class.isAssignableFrom(usedClass = usedClass.getSuperclass())) {
                clazz = knownValueEditors.get(usedClass);
            }
        }
        if (clazz != null) {
            try {
                Constructor<? extends PropertyValueCellEditor> constructor = clazz.getConstructor(usedClass);
                PropertyValueCellEditor editor = constructor.newInstance(type);
                editor.setOperator(operator);
                return editor;
            }
            catch (InstantiationException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (SecurityException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (NoSuchMethodException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalArgumentException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (InvocationTargetException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            DefaultPropertyValueCellEditor editor = new DefaultPropertyValueCellEditor(type);
            editor.setOperator(operator);
            return editor;
        }
        DefaultPropertyValueCellEditor editor = new DefaultPropertyValueCellEditor(type);
        editor.setOperator(operator);
        return editor;
    }

    public static PropertyKeyCellEditor createPropertyKeyCellEditor(PropertyTable table, ParameterType type, Operator operator, PropertyTableParameterChangeListener changeListener) {
        Class<? extends PropertyKeyCellEditor> clazz = knownKeyEditors.get(type.getClass());
        Class<?> usedClass = type.getClass();
        if (clazz == null) {
            while (clazz == null && ParameterType.class.isAssignableFrom(usedClass = usedClass.getSuperclass())) {
                clazz = knownKeyEditors.get(usedClass);
            }
        }
        if (clazz != null) {
            try {
                Constructor<? extends PropertyKeyCellEditor> constructor = clazz.getConstructor(usedClass);
                PropertyKeyCellEditor editor = constructor.newInstance(type);
                if (editor instanceof ParameterValueKeyCellEditor && changeListener != null) {
                    ((ParameterValueKeyCellEditor)editor).setParameterChangeListener(changeListener);
                }
                editor.setOperator(operator, table);
                return editor;
            }
            catch (InstantiationException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (SecurityException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (NoSuchMethodException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalArgumentException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (InvocationTargetException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            DefaultPropertyKeyRenderer editor = new DefaultPropertyKeyRenderer(type);
            editor.setOperator(operator, table);
            return editor;
        }
        DefaultPropertyKeyRenderer editor = new DefaultPropertyKeyRenderer(type);
        editor.setOperator(operator, table);
        return editor;
    }

    static {
        PropertyTable.registerPropertyKeyCellEditor(ParameterTypeParameterValue.class, ParameterValueKeyCellEditor.class);
        PropertyTable.registerPropertyKeyCellEditor(ParameterTypeList.class, DelegationKeyCellEditor.class);
        PropertyTable.registerPropertyKeyCellEditor(ParameterTypeEnumeration.class, DelegationKeyCellEditor.class);
    }
}

