/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyTable;
import com.rapidminer.gui.properties.celleditors.value.AttributeFileValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.AttributeValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.AttributesValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.ColorValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.ConfigurationWizardValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.DatabaseConnectionValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.DatabaseTableValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.DateFormatValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.DefaultPropertyValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.EnumerationValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.ExpressionValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.InnerOperatorValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.ListValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.MatrixValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.OperatorValueValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.ParameterTupelCellEditor;
import com.rapidminer.gui.properties.celleditors.value.PreviewValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.RegexpValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.RepositoryLocationValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.SQLQueryValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.SimpleFileValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.TextValueCellEditor;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeAttributeFile;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeChar;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeDatabaseConnection;
import com.rapidminer.parameter.ParameterTypeDatabaseTable;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeExpression;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInnerOperator;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeMatrix;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypePreview;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeSQLQuery;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.ParameterTypeValue;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public abstract class PropertyPanel
extends JPanel {
    private static final long serialVersionUID = -3478661102690417293L;
    private final GridBagLayout layout = new GridBagLayout();
    private final Map<String, PropertyValueCellEditor> currentEditors = new LinkedHashMap<String, PropertyValueCellEditor>();
    private Collection<ParameterType> currentTypes;
    private Color fontColor = Color.BLACK;
    public static final int VALUE_CELL_EDITOR_HEIGHT = 28;
    private static Map<Class<? extends ParameterType>, Class<? extends PropertyValueCellEditor>> knownValueEditors = new HashMap<Class<? extends ParameterType>, Class<? extends PropertyValueCellEditor>>();

    public static void registerPropertyValueCellEditor(Class<? extends ParameterType> typeClass, Class<? extends PropertyValueCellEditor> editor) {
        knownValueEditors.put(typeClass, editor);
        PropertyTable.registerPropertyValueCellEditor(typeClass, editor);
    }

    private PropertyValueCellEditor instantiateValueCellEditor(ParameterType type) {
        return PropertyPanel.instantiateValueCellEditor(type, this.getOperator());
    }

    public PropertyPanel() {
        this.setLayout(this.layout);
    }

    public void setupComponents() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setupComponentsNow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyPanel.this.setupComponentsNow();
                }
            });
        }
    }

    private void setupComponentsNow() {
        this.removeAll();
        this.currentEditors.clear();
        this.currentTypes = this.getProperties();
        if (this.currentTypes == null) {
            this.revalidate();
            this.repaint();
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.insets = new Insets(4, 4, 4, 4);
        int row = 0;
        for (final ParameterType type : this.currentTypes) {
            String range;
            StringBuilder toolTip = new StringBuilder(type.getDescription());
            if (!(type instanceof ParameterTypeCategory) && !(type instanceof ParameterTypeStringCategory) && (range = type.getRange()) != null && range.trim().length() > 0) {
                toolTip.append(" (");
                toolTip.append(type.getRange());
                toolTip.append(")");
            }
            final PropertyValueCellEditor editor = this.instantiateValueCellEditor(type);
            this.currentEditors.put(type.getKey(), editor);
            Object value = this.getValue(type);
            if (value == null) {
                value = type.getDefaultValue();
            }
            Component editorComponent = editor.getTableCellEditorComponent(null, value, false, row, 1);
            if (!this.isEnabled()) {
                SwingTools.setEnabledRecursive(editorComponent, false);
            }
            if (editorComponent instanceof JComponent) {
                ((JComponent)editorComponent).setToolTipText(toolTip.toString());
            }
            final Operator typesOperator = this.getOperator();
            editor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    Object valueObj = editor.getCellEditorValue();
                    String value = type.toString(valueObj);
                    String last = PropertyPanel.this.getValue(type);
                    if (value != null && last == null || last == null && value != null || value != null && last != null && !value.equals(last)) {
                        PropertyPanel.this.setValue(typesOperator, type, value);
                    }
                }
            });
            c.gridx = 0;
            c.gridy = row;
            c.weightx = 1.0;
            c.weighty = 0.0;
            JPanel parameterPanel = null;
            if (!editor.rendersLabel()) {
                parameterPanel = new JPanel(new GridLayout(1, 2));
                parameterPanel.setOpaque(this.isOpaque());
                parameterPanel.setBackground(this.getBackground());
                parameterPanel.setPreferredSize(new Dimension((int)parameterPanel.getPreferredSize().getWidth(), 28));
                JLabel label = new JLabel(type.getKey().replace('_', ' ') + " ");
                label.setOpaque(this.isOpaque());
                label.setFont(this.getFont());
                label.setForeground(this.fontColor);
                label.setBackground(this.getBackground());
                label.setToolTipText(toolTip.toString());
                int style = 0;
                if (!type.isOptional()) {
                    style |= 1;
                }
                if (type.isExpert()) {
                    style |= 2;
                }
                label.setFont(label.getFont().deriveFont(style));
                label.setLabelFor(editorComponent);
                if (!this.isEnabled()) {
                    SwingTools.setEnabledRecursive(label, false);
                }
                parameterPanel.add(label);
                parameterPanel.add(editorComponent);
                this.add((Component)parameterPanel, c);
            } else {
                parameterPanel = new JPanel(new BorderLayout());
                parameterPanel.setOpaque(this.isOpaque());
                parameterPanel.setBackground(this.getBackground());
                parameterPanel.setPreferredSize(new Dimension((int)parameterPanel.getPreferredSize().getWidth(), 28));
                parameterPanel.add(editorComponent, editorComponent instanceof JCheckBox ? "West" : "Center");
                this.add((Component)parameterPanel, c);
            }
            ++row;
        }
        c.gridx = 0;
        c.gridy = row;
        JPanel dummyPanel = new JPanel(new GridLayout(1, 2));
        dummyPanel.setOpaque(false);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.layout.setConstraints(dummyPanel, c);
        this.add(dummyPanel);
        this.revalidate();
        this.repaint();
    }

    protected boolean hasEditorFor(ParameterType type) {
        return this.currentEditors.containsKey(type.getKey());
    }

    protected int getNumberOfEditors() {
        return this.currentEditors.size();
    }

    protected PropertyValueCellEditor getEditorForKey(String key) {
        return this.currentEditors.get(key);
    }

    protected abstract String getValue(ParameterType var1);

    protected abstract void setValue(Operator var1, ParameterType var2, String var3);

    protected abstract Collection<ParameterType> getProperties();

    protected abstract Operator getOperator();

    public static PropertyValueCellEditor instantiateValueCellEditor(ParameterType type, Operator operator) {
        PropertyValueCellEditor editor;
        Class<?> typeClass = type.getClass();
        do {
            Class<? extends PropertyValueCellEditor> editorClass;
            if ((editorClass = knownValueEditors.get(typeClass)) != null) {
                try {
                    Constructor<? extends PropertyValueCellEditor> constructor = editorClass.getConstructor(typeClass);
                    editor = constructor.newInstance(type);
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot construct property editor: " + e, e);
                    editor = new DefaultPropertyValueCellEditor(type);
                }
                break;
            }
            typeClass = typeClass.getSuperclass();
            editor = new DefaultPropertyValueCellEditor(type);
        } while (typeClass != null);
        editor.setOperator(operator);
        return editor;
    }

    public void setLabelTextColor(Color color) {
        this.fontColor = color;
    }

    static {
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypePassword.class, DefaultPropertyValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeConfiguration.class, ConfigurationWizardValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypePreview.class, PreviewValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeColor.class, ColorValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeCategory.class, DefaultPropertyValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeStringCategory.class, DefaultPropertyValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeBoolean.class, DefaultPropertyValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeChar.class, DefaultPropertyValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeInt.class, DefaultPropertyValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeDouble.class, DefaultPropertyValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeAttributeFile.class, AttributeFileValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeFile.class, SimpleFileValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeRepositoryLocation.class, RepositoryLocationValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeValue.class, OperatorValueValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeInnerOperator.class, InnerOperatorValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeList.class, ListValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeMatrix.class, MatrixValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeExpression.class, ExpressionValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeText.class, TextValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeAttribute.class, AttributeValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeTupel.class, ParameterTupelCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeRegexp.class, RegexpValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeAttributes.class, AttributesValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeEnumeration.class, EnumerationValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeDatabaseConnection.class, DatabaseConnectionValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeDateFormat.class, DateFormatValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeSQLQuery.class, SQLQueryValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeDatabaseTable.class, DatabaseTableValueCellEditor.class);
    }
}

