/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.properties.DefaultPropertyTable;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class OperatorPropertyTable
extends DefaultPropertyTable
implements Dockable,
ProcessEditor {
    private static final long serialVersionUID = -4129852766426437419L;
    private static final Font MESSAGE_FONT = new Font("SansSerif", 0, 11);
    private static final Icon WARNING_ICON = SwingTools.createIcon("16/sign_warning.png");
    private transient Operator operator;
    private transient ParameterType[] parameterTypes;
    private boolean expertMode = false;
    private JLabel propertyMessageLabel = new JLabel();
    private final DockKey DOCK_KEY = new ResourceDockKey("property_editor");
    private JPanel component;

    @Deprecated
    public OperatorPropertyTable(final MainFrame mainFrame) {
        this.propertyMessageLabel.setMinimumSize(new Dimension(0, 0));
        this.propertyMessageLabel.setFont(MESSAGE_FONT);
        this.propertyMessageLabel.setForeground(new Color(150, 150, 150));
        this.propertyMessageLabel.setOpaque(false);
        this.propertyMessageLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.propertyMessageLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                mainFrame.TOGGLE_EXPERT_MODE_ACTION.actionPerformed(null);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.setSelection(Collections.<Operator>emptyList());
    }

    public void toggleExpertMode() {
        this.expertMode = !this.expertMode;
        this.setSelection(this.operator);
    }

    public void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void refresh() {
        this.setSelection(this.operator);
    }

    public void stopCurrentEditing() {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
    }

    @Override
    public void setSelection(List<Operator> selection) {
        this.setSelection(selection.isEmpty() ? null : selection.get(0));
    }

    public void setSelection(Operator operator) {
        this.stopCurrentEditing();
        int hidden = 0;
        this.operator = operator;
        if (operator != null) {
            Collection<ParameterType> parameters = operator.getParameters().getParameterTypes();
            LinkedList<ParameterType> viewableParameters = new LinkedList<ParameterType>();
            for (ParameterType type : parameters) {
                if (type.isHidden()) continue;
                if (this.expertMode || !type.isExpert()) {
                    viewableParameters.add(type);
                    continue;
                }
                ++hidden;
            }
            this.parameterTypes = new ParameterType[viewableParameters.size()];
            viewableParameters.toArray(this.parameterTypes);
        } else {
            this.parameterTypes = new ParameterType[0];
        }
        this.updateTableData(this.parameterTypes.length);
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            this.getModel().setValueAt(this.parameterTypes[i].getKey(), i, 0);
            Object value = this.parameterTypes[i].getDefaultValue();
            try {
                value = operator.getParameters().getParameter(this.parameterTypes[i].getKey());
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            this.getModel().setValueAt(value, i, 1);
        }
        this.updateEditorsAndRenderers();
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                OperatorPropertyTable.this.setValue(e.getFirstRow(), OperatorPropertyTable.this.getModel().getValueAt(e.getFirstRow(), 1));
                OperatorPropertyTable.this.getModel().removeTableModelListener(this);
                OperatorPropertyTable.this.refresh();
            }
        });
        if (hidden == 1) {
            this.propertyMessageLabel.setText("There is 1 hidden parameter shown in expert mode only.");
            if (WARNING_ICON != null) {
                this.propertyMessageLabel.setIcon(WARNING_ICON);
            }
            this.propertyMessageLabel.setCursor(new Cursor(12));
        } else if (hidden > 1) {
            this.propertyMessageLabel.setText("There are " + hidden + " hidden parameters shown in expert mode only.");
            if (WARNING_ICON != null) {
                this.propertyMessageLabel.setIcon(WARNING_ICON);
            }
            this.propertyMessageLabel.setCursor(new Cursor(12));
        } else {
            this.propertyMessageLabel.setText(null);
            this.propertyMessageLabel.setIcon(null);
            this.propertyMessageLabel.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    @Override
    public Operator getOperator(int row) {
        return this.operator;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new JPanel(new BorderLayout());
            this.component.add((Component)new JScrollPane(this), "Center");
            this.component.add((Component)this.propertyMessageLabel, "South");
        }
        return this.component;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }

    @Override
    public void processChanged(Process process) {
    }

    @Override
    public void processUpdated(Process process) {
    }
}

