/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.actions.ToggleAction;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.properties.CompatibilityLevelSpinnerModel;
import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.gui.tools.components.ToggleDropDownButton;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OperatorPropertyPanel
extends PropertyPanel
implements Dockable,
ProcessEditor {
    private static final long serialVersionUID = 6056794546696461864L;
    private final BreakpointButton breakpointButton;
    private final MainFrame mainFrame;
    private static final Icon WARNING_ICON = SwingTools.createIcon("16/sign_warning.png");
    private final JLabel headerLabel = new JLabel("");
    private final Font selectedFont = this.headerLabel.getFont().deriveFont(1);
    private final Font unselectedFont = this.headerLabel.getFont();
    private final JLabel expertModeHintLabel = new JLabel("");
    private Operator operator;
    private final Observer<String> parameterObserver = new Observer<String>(){

        @Override
        public void update(Observable<String> observable, String key) {
            PropertyValueCellEditor editor = OperatorPropertyPanel.this.getEditorForKey(key);
            if (editor != null) {
                ParameterType type = OperatorPropertyPanel.this.operator.getParameters().getParameterType(key);
                String editorValue = type.toString(editor.getCellEditorValue());
                String opValue = OperatorPropertyPanel.this.operator.getParameters().getParameterOrNull(key);
                if (opValue != null && editorValue == null || opValue == null && editorValue != null || opValue != null && editorValue != null && !opValue.equals(editorValue)) {
                    editor.getTableCellEditorComponent(null, opValue, false, 0, 1);
                }
            } else {
                OperatorPropertyPanel.this.setupComponents();
            }
        }
    };
    private JSpinner compatibilityLevelSpinner = new JSpinner(new CompatibilityLevelSpinnerModel());
    private ResourceLabel compatibilityLabel = new ResourceLabel("compatibility_level", new Object[0]);
    private JPanel compatibilityPanel = new JPanel(new FlowLayout(3));
    public static final String PROPERTY_EDITOR_DOCK_KEY = "property_editor";
    private final DockKey DOCK_KEY = new ResourceDockKey("property_editor");
    private JPanel dockableComponent;

    public OperatorPropertyPanel(final MainFrame mainFrame) {
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.mainFrame = mainFrame;
        this.breakpointButton = new BreakpointButton();
        this.headerLabel.setHorizontalAlignment(0);
        this.expertModeHintLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.expertModeHintLabel.setIcon(WARNING_ICON);
        this.expertModeHintLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                mainFrame.TOGGLE_EXPERT_MODE_ACTION.actionPerformed(null);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.expertModeHintLabel.setCursor(new Cursor(12));
        this.expertModeHintLabel.setHorizontalAlignment(2);
        this.setupComponents();
        this.compatibilityLevelSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OperatorVersion[] versionChanges = OperatorPropertyPanel.this.operator.getIncompatibleVersionChanges();
                if (versionChanges.length != 0) {
                    OperatorVersion latestChange = versionChanges[versionChanges.length - 1];
                    if (latestChange.isAtLeast(OperatorPropertyPanel.this.operator.getCompatibilityLevel())) {
                        OperatorPropertyPanel.this.compatibilityLabel.setIcon(WARNING_ICON);
                    } else {
                        OperatorPropertyPanel.this.compatibilityLabel.setIcon(SwingTools.createIcon("16/ok.png"));
                    }
                }
            }
        });
    }

    @Override
    protected String getValue(ParameterType type) {
        return this.operator.getParameters().getParameterOrNull(type.getKey());
    }

    @Override
    protected void setValue(Operator operator, ParameterType type, String value) {
        if (value.length() == 0) {
            value = null;
        }
        operator.setParameter(type.getKey(), value);
    }

    protected List<ParameterType> getProperties() {
        LinkedList<ParameterType> visible = new LinkedList<ParameterType>();
        int hidden = 0;
        if (this.operator != null) {
            for (ParameterType type : this.operator.getParameters().getParameterTypes()) {
                if (type.isHidden()) continue;
                if (!this.isExpertMode() && type.isExpert()) {
                    ++hidden;
                    continue;
                }
                visible.add(type);
            }
        }
        if (hidden > 0) {
            this.expertModeHintLabel.setText(hidden + " hidden expert parameter" + (hidden == 1 ? "" : "s"));
            this.expertModeHintLabel.setVisible(true);
        } else {
            this.expertModeHintLabel.setVisible(false);
        }
        return visible;
    }

    @Override
    public void processChanged(Process process) {
    }

    @Override
    public void processUpdated(Process process) {
        this.setNameFor(this.operator);
        int count = 0;
        Collection properties = this.getProperties();
        if (properties.size() != this.getNumberOfEditors()) {
            this.setupComponents();
            return;
        }
        for (ParameterType type : properties) {
            if (this.hasEditorFor(type)) {
                ++count;
                continue;
            }
            this.setupComponents();
            return;
        }
        if (count != properties.size()) {
            this.setupComponents();
        }
    }

    @Override
    public void setSelection(List<Operator> selection) {
        Operator operator;
        Operator operator2 = operator = selection.isEmpty() ? null : selection.get(0);
        if (operator == this.operator) {
            return;
        }
        if (this.operator != null) {
            this.operator.getParameters().removeObserver(this.parameterObserver);
        }
        this.operator = operator;
        if (operator != null) {
            this.operator.getParameters().addObserver(this.parameterObserver, true);
            this.breakpointButton.setEnabled(true);
            OperatorVersion[] versionChanges = operator.getIncompatibleVersionChanges();
            if (versionChanges.length == 0) {
                this.compatibilityLevelSpinner.setVisible(false);
                this.compatibilityLabel.setVisible(false);
            } else {
                this.compatibilityLevelSpinner.setVisible(true);
                this.compatibilityLabel.setVisible(true);
                ((CompatibilityLevelSpinnerModel)this.compatibilityLevelSpinner.getModel()).setOperator(operator);
            }
        } else {
            this.breakpointButton.setEnabled(false);
        }
        this.setNameFor(operator);
        this.setupComponents();
    }

    private void setNameFor(Operator operator) {
        if (operator != null) {
            this.headerLabel.setFont(this.selectedFont);
            if (operator.getName().equals(operator.getOperatorDescription().getName())) {
                this.headerLabel.setText(operator.getName());
            } else {
                this.headerLabel.setText(operator.getName() + " (" + operator.getOperatorDescription().getName() + ")");
            }
            this.headerLabel.setIcon(operator.getOperatorDescription().getSmallIcon());
        } else {
            this.headerLabel.setFont(this.unselectedFont);
            this.headerLabel.setText("No Operator Selected");
            this.headerLabel.setIcon(null);
        }
    }

    public Component getComponent() {
        if (this.dockableComponent == null) {
            ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setBorder(null);
            this.dockableComponent = new JPanel(new BorderLayout());
            JPanel toolBarPanel = new JPanel(new BorderLayout());
            ViewToolBar toolBar = new ViewToolBar();
            JToggleButton toggleExpertModeButton = this.mainFrame.TOGGLE_EXPERT_MODE_ACTION.createToggleButton();
            toggleExpertModeButton.setText(null);
            toolBar.add(toggleExpertModeButton);
            toolBar.add(this.mainFrame.getActions().INFO_OPERATOR_ACTION);
            JToggleButton enableOperatorButton = this.mainFrame.getActions().TOGGLE_ACTIVATION_ITEM.createToggleButton();
            enableOperatorButton.setText(null);
            toolBar.add(enableOperatorButton);
            toolBar.add(this.mainFrame.getActions().RENAME_OPERATOR_ACTION);
            toolBar.add(this.mainFrame.getActions().DELETE_OPERATOR_ACTION);
            this.breakpointButton.addToToolBar(toolBar);
            toolBarPanel.add((Component)toolBar, "North");
            JPanel headerPanel = new JPanel();
            headerPanel.setBackground(SwingTools.LIGHTEST_BLUE);
            headerPanel.add(this.headerLabel);
            headerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
            toolBarPanel.add((Component)headerPanel, "South");
            this.dockableComponent.add((Component)toolBarPanel, "North");
            this.dockableComponent.add((Component)scrollPane, "Center");
            JPanel southPanel = new JPanel(new BorderLayout());
            southPanel.add((Component)this.expertModeHintLabel, "Center");
            this.compatibilityLabel.setLabelFor(this.compatibilityLevelSpinner);
            this.compatibilityLevelSpinner.setPreferredSize(new Dimension(80, (int)this.compatibilityLevelSpinner.getPreferredSize().getHeight()));
            this.compatibilityPanel.add(this.compatibilityLabel);
            this.compatibilityPanel.add(this.compatibilityLevelSpinner);
            southPanel.add((Component)this.compatibilityPanel, "South");
            this.dockableComponent.add((Component)southPanel, "South");
        }
        return this.dockableComponent;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }

    public boolean isExpertMode() {
        return this.mainFrame.TOGGLE_EXPERT_MODE_ACTION.isSelected();
    }

    @Override
    protected Operator getOperator() {
        return this.operator;
    }

    private class BreakpointButton
    extends ToggleDropDownButton
    implements ToggleAction.ToggleActionListener {
        private static final long serialVersionUID = 7364886954405951709L;
        private final Icon IMAGE_BREAKPOINTS;
        private final Icon IMAGE_BREAKPOINT_BEFORE;
        private final Icon IMAGE_BREAKPOINT_AFTER;

        public BreakpointButton() {
            super(new ResourceAction(true, "breakpoint_after", new Object[0]){
                private static final long serialVersionUID = -8913366165786891652L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT[0].isSelected() || ((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT[1].isSelected()) {
                        ((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT[0].resetAction(false);
                        ((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT[1].resetAction(false);
                        return;
                    }
                    ((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT[1].actionPerformed(null);
                }
            });
            this.IMAGE_BREAKPOINTS = SwingTools.createIcon("16/breakpoints.png");
            this.IMAGE_BREAKPOINT_BEFORE = SwingTools.createIcon("16/breakpoint_up.png");
            this.IMAGE_BREAKPOINT_AFTER = SwingTools.createIcon("16/breakpoint_down.png");
            for (int i = 0; i < ((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT.length; ++i) {
                ((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT[i].addToggleActionListener(this);
            }
        }

        @Override
        public void setSelected(boolean selected) {
            Icon breakpointIcon;
            if (OperatorPropertyPanel.this.operator != null && OperatorPropertyPanel.this.operator.hasBreakpoint()) {
                super.setSelected(true);
                breakpointIcon = OperatorPropertyPanel.this.operator.getNumberOfBreakpoints() == 1 ? (OperatorPropertyPanel.this.operator.hasBreakpoint(0) ? this.IMAGE_BREAKPOINT_BEFORE : this.IMAGE_BREAKPOINT_AFTER) : this.IMAGE_BREAKPOINTS;
            } else {
                super.setSelected(false);
                breakpointIcon = this.IMAGE_BREAKPOINT_AFTER;
            }
            this.setIcon(breakpointIcon);
        }

        @Override
        protected JPopupMenu getPopupMenu() {
            JPopupMenu menu = new JPopupMenu();
            for (int i = 0; i < ((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT.length; ++i) {
                menu.add(((OperatorPropertyPanel)OperatorPropertyPanel.this).mainFrame.getActions().TOGGLE_BREAKPOINT[i].createMenuItem());
            }
            return menu;
        }
    }
}

