/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.MatrixPropertyTable;
import com.rapidminer.gui.properties.PropertyDialog;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeMatrix;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;

public class MatrixPropertyDialog
extends PropertyDialog {
    private static final long serialVersionUID = 5396725165122306231L;
    private boolean isSquared = false;
    private final MatrixPropertyTable matrixPropertyTable;

    public MatrixPropertyDialog(ParameterTypeMatrix type, double[][] matrix, Operator operator) {
        super(type, "matrix");
        this.isSquared = type.isSquared();
        this.matrixPropertyTable = new MatrixPropertyTable(type.getBaseName(), type.getRowBaseName(), type.getColumnBaseName(), matrix, operator);
        LinkedList<JButton> buttons = new LinkedList<JButton>();
        if (!this.isSquared) {
            buttons.add(new JButton(new ResourceAction("matrix.add_row", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.addRow();
                }
            }));
            buttons.add(new JButton(new ResourceAction("matrix.add_column", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.addColumn();
                }
            }));
            buttons.add(new JButton(new ResourceAction("matrix.remove_row", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.removeSelectedRow();
                }
            }));
            buttons.add(new JButton(new ResourceAction("matrix.remove_column", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.removeSelectedColumn();
                }
            }));
        } else {
            buttons.add(new JButton(new ResourceAction("matrix.increase_size", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.addRow();
                    MatrixPropertyDialog.this.matrixPropertyTable.addColumn();
                    MatrixPropertyDialog.this.matrixPropertyTable.fillNewRowAndColumn();
                }
            }));
            buttons.add(new JButton(new ResourceAction("matrix.decrease_size", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.removeSelectedRowAndColumn();
                }
            }));
        }
        buttons.add(this.makeOkButton());
        buttons.add(this.makeCancelButton());
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.matrixPropertyTable);
        scrollPane.setBorder(MatrixPropertyDialog.createBorder());
        this.layoutDefault((JComponent)scrollPane, 1, buttons.toArray(new AbstractButton[buttons.size()]));
    }

    public double[][] getMatrix() {
        return this.matrixPropertyTable.getParameterMatrix();
    }
}

