/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.parameter.ParameterType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ListTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<String[]> parameterList;
    private ParameterType[] types;

    public ListTableModel(ParameterType[] types, List<String[]> parameterList) {
        this.types = types;
        this.parameterList = new ArrayList<String[]>(parameterList);
    }

    @Override
    public String getColumnName(int column) {
        return this.types[column].getKey().replace('_', ' ');
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.parameterList.size();
    }

    @Override
    public int getColumnCount() {
        return this.types.length;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ParameterType columnType = this.types[columnIndex];
        this.parameterList.get((int)rowIndex)[columnIndex] = aValue == null ? columnType.getDefaultValueAsString() : aValue.toString();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.parameterList.get(rowIndex)[columnIndex];
    }

    void addRow() {
        String[] initialValues = new String[this.types.length];
        for (int i = 0; i < initialValues.length; ++i) {
            initialValues[i] = this.types[i].getDefaultValueAsString();
        }
        this.parameterList.add(initialValues);
        this.fireTableRowsInserted(this.parameterList.size() - 1, this.parameterList.size() - 1);
    }

    public void removeRow(int selectedRow) {
        this.parameterList.remove(selectedRow);
        this.fireTableRowsDeleted(selectedRow, selectedRow);
    }

    public List<String[]> getParameterList() {
        return this.parameterList;
    }
}

