/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.ListTableModel;
import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ListPropertyTable2
extends JTable {
    private static final long serialVersionUID = 1L;
    private List<TableCellRenderer[]> renderers = new LinkedList<TableCellRenderer[]>();
    private List<TableCellEditor[]> editors = new LinkedList<TableCellEditor[]>();
    private ParameterType[] types;
    private Operator operator;

    public ListPropertyTable2(ParameterTypeList type, List<String[]> parameterList, Operator operator) {
        this(new ParameterType[]{type.getKeyType(), type.getValueType()}, parameterList, operator);
    }

    public ListPropertyTable2(ParameterTypeEnumeration type, List<String> parameterList, Operator operator) {
        this(new ParameterType[]{type.getValueType()}, ListPropertyTable2.to2DimList(parameterList), operator);
    }

    private ListPropertyTable2(ParameterType[] types, List<String[]> parameterList, Operator operator) {
        this.types = types;
        this.operator = operator;
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setRowHeight(28);
        this.setModel(new ListTableModel(types, parameterList));
        this.fillEditors();
    }

    private static List<String[]> to2DimList(List<String> parameterList) {
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (String v : parameterList) {
            result.add(new String[]{v});
        }
        return result;
    }

    public void addRow() {
        ((ListTableModel)this.getModel()).addRow();
        this.fillEditors();
    }

    private void fillEditors() {
        while (this.editors.size() < this.getModel().getRowCount()) {
            TableCellRenderer[] rowRenderers = new TableCellRenderer[this.types.length];
            TableCellEditor[] rowEditors = new TableCellEditor[this.types.length];
            for (int i = 0; i < this.types.length; ++i) {
                rowRenderers[i] = PropertyPanel.instantiateValueCellEditor(this.types[i], this.operator);
                rowEditors[i] = PropertyPanel.instantiateValueCellEditor(this.types[i], this.operator);
            }
            this.renderers.add(rowRenderers);
            this.editors.add(rowEditors);
        }
    }

    public void removeSelected() {
        if (this.getSelectedRow() != -1) {
            ((ListTableModel)this.getModel()).removeRow(this.getSelectedRow());
        }
    }

    public void storeParameterList(List<String[]> parameterList2) {
        parameterList2.clear();
        parameterList2.addAll(((ListTableModel)this.getModel()).getParameterList());
    }

    public void storeParameterEnumeration(List<String> parameterList2) {
        parameterList2.clear();
        for (String[] values : ((ListTableModel)this.getModel()).getParameterList()) {
            parameterList2.add(values[0]);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.renderers.get(row)[column];
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        return this.editors.get(row)[column];
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String range;
        Point p = e.getPoint();
        int column = this.columnAtPoint(p);
        ParameterType type = this.types[column];
        StringBuffer toolTip = new StringBuffer(type.getDescription());
        if (!(type instanceof ParameterTypeCategory) && !(type instanceof ParameterTypeStringCategory) && (range = type.getRange()) != null && range.trim().length() > 0) {
            toolTip.append(" (");
            toolTip.append(type.getRange());
            toolTip.append(")");
        }
        String toolTipText = SwingTools.transformToolTipText(toolTip.toString());
        return toolTipText;
    }
}

