/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;

public class ListPropertyTable
extends PropertyTable {
    private static final long serialVersionUID = -4547732551646588939L;
    private transient ParameterTypeList type;
    private transient Operator operator;
    private transient String keyToolTip;

    public ListPropertyTable(ParameterTypeList type, List<String[]> parameterList, Operator operator) {
        super(new String[]{type.getKeyType().getKey().replaceAll("_", " "), type.getValueType().getKey().replaceAll("_", " ")});
        String range;
        this.type = type;
        this.operator = operator;
        this.updateTableData(parameterList.size());
        this.updateEditorsAndRenderers();
        Iterator<String[]> i = parameterList.iterator();
        int j = 0;
        while (i.hasNext()) {
            String[] keyValue = i.next();
            this.getModel().setValueAt(keyValue[0], j, 0);
            this.getModel().setValueAt(keyValue[1], j, 1);
            ++j;
        }
        ParameterType keyType = type.getKeyType();
        StringBuffer toolTip = new StringBuffer(keyType.getDescription());
        if (!(keyType instanceof ParameterTypeCategory) && !(keyType instanceof ParameterTypeStringCategory) && (range = keyType.getRange()) != null && range.trim().length() > 0) {
            toolTip.append(" (");
            toolTip.append(keyType.getRange());
            toolTip.append(")");
        }
        this.keyToolTip = SwingTools.transformToolTipText(toolTip.toString());
    }

    public void addRow() {
        this.getDefaultModel().addRow(new Object[]{"", this.type.getValueType().getDefaultValue()});
        this.updateEditorsAndRenderers();
        int lastIndex = this.getRowCount() - 1;
        this.getModel().setValueAt(this.getKeyEditor(lastIndex).getCellEditorValue(), lastIndex, 0);
    }

    public void removeSelected() {
        int[] selectedRow = this.getSelectedRows();
        for (int i = selectedRow.length - 1; i >= 0; --i) {
            this.getDefaultModel().removeRow(selectedRow[i]);
        }
        this.getDefaultModel().fireTableStructureChanged();
    }

    public void storeParameterList(List<String[]> list) {
        list.clear();
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            String firstString = null;
            Object firstObject = this.getModel().getValueAt(i, 0);
            if (firstObject instanceof String) {
                firstString = (String)firstObject;
            } else if (firstObject != null) {
                firstString = firstObject.toString();
            }
            String secondString = null;
            Object secondObject = this.getModel().getValueAt(i, 1);
            if (secondObject instanceof String) {
                secondString = (String)secondObject;
            } else if (secondObject != null) {
                secondString = secondObject.toString();
            }
            list.add(new String[]{firstString, secondString});
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int column = this.columnAtPoint(p);
        if (column == 0) {
            return this.keyToolTip;
        }
        return super.getToolTipText(e);
    }

    @Override
    public Operator getOperator(int row) {
        return this.operator;
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.type.getValueType();
    }

    @Override
    public ParameterType getKeyParameterType(int row) {
        return this.type;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.getModel().setValueAt(this.getCellEditor().getCellEditorValue(), this.getEditingRow(), this.getEditingColumn());
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.getModel().setValueAt(this.getCellEditor().getCellEditorValue(), this.getEditingRow(), this.getEditingColumn());
    }
}

