/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Collection;
import java.util.LinkedList;

public class GenericParameterPanel
extends PropertyPanel {
    private static final long serialVersionUID = -8633435565053835262L;
    private Parameters parameters = null;

    public GenericParameterPanel() {
    }

    public GenericParameterPanel(Parameters parameters) {
        this.setParameters(parameters);
    }

    @Override
    protected Operator getOperator() {
        return null;
    }

    @Override
    protected Collection<ParameterType> getProperties() {
        LinkedList<ParameterType> visible = new LinkedList<ParameterType>();
        if (this.parameters != null) {
            for (ParameterType type : this.parameters.getParameterTypes()) {
                if (type.isHidden()) continue;
                visible.add(type);
            }
        }
        return visible;
    }

    @Override
    protected String getValue(ParameterType type) {
        try {
            return this.parameters.getParameter(type.getKey());
        }
        catch (UndefinedParameterError e) {
            return type.getDefaultValueAsString();
        }
    }

    @Override
    protected void setValue(Operator operator, ParameterType type, String value) {
        this.parameters.setParameter(type.getKey(), value);
        this.setupComponents();
    }

    public void setValue(String key, String value) {
        this.parameters.setParameter(key, value);
        this.setupComponents();
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
        this.setupComponents();
    }

    public void clearProperties() {
        this.parameters = null;
        this.setupComponents();
    }

    public Parameters getParameters() {
        return this.parameters;
    }
}

