/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyDialog;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.parameter.ParameterTypeExpression;
import com.rapidminer.tools.math.function.ExpressionParser;
import com.rapidminer.tools.math.function.FunctionDescription;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ExpressionPropertyDialog
extends PropertyDialog {
    private static final long serialVersionUID = 5567661137372752202L;
    private static final int FUNCTION_ROW_LENGTH = 4;
    private JTextField currentExpression = new JTextField();
    private static final String OK_ICON_NAME = "ok.png";
    private static final String ERROR_ICON_NAME = "error.png";
    private static Icon OK_ICON = null;
    private static Icon ERROR_ICON = null;
    private JLabel validationLabel = new JLabel();
    private JLabel validationIcon = new JLabel(ERROR_ICON);
    private ExpressionParser parser = new ExpressionParser(true);
    private JScrollPane functionButtonScrollPane;
    private JPanel functionsButtonsPanel = new JPanel();
    private GridBagLayout functionButtonsLayout = new GridBagLayout();
    private GridBagConstraints functionButtonsC = new GridBagConstraints();

    public ExpressionPropertyDialog(ParameterTypeExpression type, String initialValue) {
        super(type, "expression");
        Vector<String> knownAttributes = new Vector<String>();
        InputPort inPort = ((ParameterTypeExpression)this.getParameterType()).getInputPort();
        if (inPort != null) {
            ExampleSetMetaData emd;
            ModelMetaData mmd;
            if (inPort.getMetaData() instanceof ExampleSetMetaData) {
                ExampleSetMetaData emd2 = (ExampleSetMetaData)inPort.getMetaData();
                for (AttributeMetaData amd : emd2.getAllAttributes()) {
                    knownAttributes.add(amd.getName());
                }
            } else if (inPort.getMetaData() instanceof ModelMetaData && (mmd = (ModelMetaData)inPort.getMetaData()) != null && (emd = mmd.getTrainingSetMetaData()) != null) {
                for (AttributeMetaData amd : emd.getAllAttributes()) {
                    knownAttributes.add(amd.getName());
                }
            }
        }
        Collections.sort(knownAttributes);
        LinkedList<JButton> buttons = new LinkedList<JButton>();
        buttons.add(this.makeOkButton());
        buttons.add(this.makeCancelButton());
        JPanel mainPanel = new JPanel();
        GridBagLayout mainLayout = new GridBagLayout();
        mainPanel.setLayout(mainLayout);
        GridBagConstraints mainC = new GridBagConstraints();
        mainC.fill = 1;
        mainC.weightx = 1.0;
        mainC.weighty = 0.0;
        mainC.insets = new Insets(7, 7, 7, 7);
        JPanel expressionPanel = new JPanel();
        GridBagLayout expressionLayout = new GridBagLayout();
        expressionPanel.setLayout(expressionLayout);
        GridBagConstraints expressionC = new GridBagConstraints();
        expressionC.fill = 1;
        expressionC.insets = new Insets(7, 7, 7, 7);
        expressionC.weightx = 0.0;
        expressionC.weighty = 0.0;
        JLabel label = new JLabel("Expression:");
        expressionLayout.setConstraints(label, expressionC);
        expressionPanel.add(label);
        this.currentExpression.setPreferredSize(new Dimension(200, 23));
        this.currentExpression.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ExpressionPropertyDialog.this.validateExpression();
            }
        });
        expressionC.weightx = 1.0;
        expressionC.gridwidth = 0;
        expressionLayout.setConstraints(this.currentExpression, expressionC);
        expressionPanel.add(this.currentExpression);
        expressionC.weightx = 0.0;
        expressionC.gridwidth = -1;
        expressionLayout.setConstraints(this.validationIcon, expressionC);
        expressionPanel.add(this.validationIcon);
        Dimension dimension200to30 = new Dimension(200, 30);
        this.validationLabel.setPreferredSize(dimension200to30);
        this.validationLabel.setMinimumSize(dimension200to30);
        this.validationLabel.setMaximumSize(dimension200to30);
        this.validationLabel.setAlignmentX(1.0f);
        expressionC.weightx = 1.0;
        expressionC.gridwidth = 0;
        expressionLayout.setConstraints(this.validationLabel, expressionC);
        expressionPanel.add(this.validationLabel);
        expressionC.weightx = 0.0;
        expressionC.gridwidth = -1;
        JLabel hiddenLabel = new JLabel();
        expressionLayout.setConstraints(hiddenLabel, expressionC);
        expressionPanel.add(hiddenLabel);
        final JCheckBox allowUndeclaredBox = new JCheckBox("Allow Unknown?", false);
        allowUndeclaredBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionPropertyDialog.this.setAllowUndeclared(allowUndeclaredBox.isSelected());
            }
        });
        this.setAllowUndeclared(false);
        expressionC.weightx = 0.0;
        expressionC.anchor = 17;
        expressionC.gridwidth = 0;
        expressionLayout.setConstraints(allowUndeclaredBox, expressionC);
        expressionPanel.add(allowUndeclaredBox);
        mainC.gridwidth = 0;
        mainLayout.setConstraints(expressionPanel, mainC);
        mainPanel.add(expressionPanel);
        JPanel functionPanel = new JPanel();
        GridBagLayout functionsLayout = new GridBagLayout();
        functionPanel.setLayout(functionsLayout);
        functionPanel.setBorder(BorderFactory.createTitledBorder("Functions"));
        GridBagConstraints functionsC = new GridBagConstraints();
        functionsC.fill = 1;
        functionsC.insets = new Insets(7, 7, 7, 7);
        functionsC.weightx = 0.0;
        functionsC.weighty = 0.0;
        label = new JLabel("Type:");
        functionsLayout.setConstraints(label, functionsC);
        functionPanel.add(label);
        final JComboBox<String> functionsTypeBox = new JComboBox<String>(this.parser.getFunctionGroups());
        functionsTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionPropertyDialog.this.updateFunctions((String)functionsTypeBox.getSelectedItem());
            }
        });
        functionsC.gridwidth = 0;
        functionsC.weightx = 1.0;
        functionsLayout.setConstraints(functionsTypeBox, functionsC);
        functionPanel.add(functionsTypeBox);
        this.functionsButtonsPanel.setLayout(this.functionButtonsLayout);
        this.functionButtonsC.fill = 1;
        this.functionButtonsC.anchor = 18;
        this.functionButtonsC.insets = new Insets(7, 7, 7, 7);
        this.functionButtonsC.weightx = 1.0;
        this.functionButtonsC.weighty = 0.0;
        this.updateFunctions(this.parser.getFunctionGroups()[0]);
        JPanel outerButtonPanel = new JPanel();
        outerButtonPanel.setLayout(new GridBagLayout());
        GridBagConstraints outerButtonC = new GridBagConstraints();
        outerButtonC.gridwidth = 0;
        outerButtonC.fill = 2;
        outerButtonC.weightx = 1.0;
        outerButtonC.weighty = 1.0;
        outerButtonC.anchor = 18;
        outerButtonPanel.add((Component)this.functionsButtonsPanel, outerButtonC);
        outerButtonC.weighty = 1.0;
        outerButtonC.fill = 1;
        outerButtonPanel.add((Component)new JPanel(), outerButtonC);
        functionsC.weightx = 0.0;
        functionsC.weighty = 1.0;
        functionsC.anchor = 11;
        this.functionButtonScrollPane = new JScrollPane(outerButtonPanel);
        this.functionButtonScrollPane.setVerticalScrollBarPolicy(20);
        functionsLayout.setConstraints(this.functionButtonScrollPane, functionsC);
        functionPanel.add(this.functionButtonScrollPane);
        JPanel attributesPanel = new JPanel();
        GridBagLayout attributesLayout = new GridBagLayout();
        attributesPanel.setLayout(attributesLayout);
        GridBagConstraints attributesC = new GridBagConstraints();
        attributesC.fill = 1;
        attributesC.insets = new Insets(7, 7, 7, 7);
        attributesC.weightx = 1.0;
        attributesC.weighty = 1.0;
        final JList attributeList = new JList(knownAttributes);
        attributeList.setSelectionMode(0);
        attributeList.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ExpressionPropertyDialog.this.addToExpression(attributeList.getSelectedValue().toString());
                }
            }
        });
        attributesC.gridwidth = 0;
        attributesLayout.setConstraints(attributeList, attributesC);
        attributesPanel.add(attributeList);
        mainC.weighty = 1.0;
        mainC.weightx = 0.6;
        mainC.gridwidth = -1;
        mainLayout.setConstraints(functionPanel, mainC);
        mainPanel.add(functionPanel);
        mainC.weightx = 0.4;
        JScrollPane attributeScrollPane = new JScrollPane(attributesPanel);
        attributeScrollPane.setBorder(BorderFactory.createTitledBorder("Attributes"));
        mainLayout.setConstraints(attributeScrollPane, mainC);
        mainPanel.add(attributeScrollPane);
        this.layoutDefault((JComponent)mainPanel, 1, buttons.toArray(new AbstractButton[buttons.size()]));
        if (initialValue != null) {
            this.currentExpression.setText(initialValue);
        }
        this.validateExpression();
        this.setSize(850, 675);
    }

    private void setAllowUndeclared(boolean allowUndeclared) {
        this.parser.initParser(true);
        if (allowUndeclared) {
            this.parser.getParser().setAllowUndeclared(true);
        } else {
            InputPort inPort = ((ParameterTypeExpression)this.getParameterType()).getInputPort();
            if (inPort != null) {
                ExampleSetMetaData emd;
                ModelMetaData mmd;
                if (inPort.getMetaData() instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd2 = (ExampleSetMetaData)inPort.getMetaData();
                    for (AttributeMetaData amd : emd2.getAllAttributes()) {
                        if (amd.isNominal()) {
                            this.parser.getParser().addVariable(amd.getName(), (Object)"");
                            continue;
                        }
                        this.parser.getParser().addVariable(amd.getName(), Double.NaN);
                    }
                } else if (inPort.getMetaData() instanceof ModelMetaData && (mmd = (ModelMetaData)inPort.getMetaData()) != null && (emd = mmd.getTrainingSetMetaData()) != null) {
                    for (AttributeMetaData amd : emd.getAllAttributes()) {
                        if (amd.isNominal()) {
                            this.parser.getParser().addVariable(amd.getName(), (Object)"");
                            continue;
                        }
                        this.parser.getParser().addVariable(amd.getName(), Double.NaN);
                    }
                }
            }
        }
        this.validateExpression();
        this.requestExpressionFocus();
    }

    private void addToExpression(String value) {
        if (value == null) {
            return;
        }
        String selectedText = this.currentExpression.getSelectedText();
        if (selectedText != null && selectedText.length() > 0) {
            if (value.endsWith("()")) {
                int selectionStart = this.currentExpression.getSelectionStart();
                int selectionEnd = this.currentExpression.getSelectionEnd();
                String text = this.currentExpression.getText();
                String firstPart = text.substring(0, selectionStart);
                String lastPart = text.substring(selectionEnd);
                this.currentExpression.setText(firstPart + value + lastPart);
                int lengthForCaretPosition = value.length();
                if (value.endsWith("()")) {
                    --lengthForCaretPosition;
                }
                this.currentExpression.setCaretPosition(selectionStart + lengthForCaretPosition);
                this.addToExpression(selectedText);
                this.currentExpression.setCaretPosition(this.currentExpression.getCaretPosition() + 1);
                this.validateExpression();
                this.requestExpressionFocus();
            } else {
                int selectionStart = this.currentExpression.getSelectionStart();
                int selectionEnd = this.currentExpression.getSelectionEnd();
                String text = this.currentExpression.getText();
                String firstPart = text.substring(0, selectionStart);
                String lastPart = text.substring(selectionEnd);
                this.currentExpression.setText(firstPart + value + lastPart);
                int lengthForCaretPosition = value.length();
                if (value.endsWith("()")) {
                    --lengthForCaretPosition;
                }
                this.currentExpression.setCaretPosition(selectionStart + lengthForCaretPosition);
                this.validateExpression();
                this.requestExpressionFocus();
            }
        } else {
            int caretPosition = this.currentExpression.getCaretPosition();
            String text = this.currentExpression.getText();
            if (text != null && text.length() > 0) {
                String firstPart = text.substring(0, caretPosition);
                String lastPart = text.substring(caretPosition);
                this.currentExpression.setText(firstPart + value + lastPart);
                int lengthForCaretPosition = value.length();
                if (value.endsWith("()")) {
                    --lengthForCaretPosition;
                }
                this.currentExpression.setCaretPosition(caretPosition + lengthForCaretPosition);
            } else {
                this.currentExpression.setText(value);
                int lengthForCaretPosition = value.length();
                if (value.endsWith("()")) {
                    --lengthForCaretPosition;
                }
                this.currentExpression.setCaretPosition(caretPosition + lengthForCaretPosition);
                this.currentExpression.setCaretPosition(lengthForCaretPosition);
            }
            this.validateExpression();
            this.requestExpressionFocus();
        }
    }

    private void requestExpressionFocus() {
        this.currentExpression.requestFocusInWindow();
    }

    private void updateFunctions(String functionGroup) {
        int funtionRowLength = 4;
        if (functionGroup.equals("Date")) {
            --funtionRowLength;
        }
        this.functionsButtonsPanel.removeAll();
        List<FunctionDescription> functions = this.parser.getFunctions(functionGroup);
        this.functionButtonsC.gridwidth = 1;
        for (int i = 0; i < funtionRowLength - 1; ++i) {
            this.functionsButtonsPanel.add((Component)new JLabel(), this.functionButtonsC);
        }
        this.functionButtonsC.gridwidth = 0;
        this.functionsButtonsPanel.add((Component)new JLabel(), this.functionButtonsC);
        this.functionButtonsC.gridwidth = 1;
        int index = 1;
        for (final FunctionDescription currentFunction : functions) {
            JButton currentButton = new JButton();
            currentButton.setText(currentFunction.getFunction());
            String argumentString = null;
            int numberOfArguments = currentFunction.getNumberOfArguments();
            argumentString = numberOfArguments == -1 ? "unlimited arguments" : (numberOfArguments == 1 ? "1 argument" : numberOfArguments + " arguments");
            currentButton.setToolTipText("<html><b>" + currentFunction.getName() + "</b>: " + currentFunction.getDescription() + " (<i>" + argumentString + "</i>)</html>");
            currentButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExpressionPropertyDialog.this.addToExpression(currentFunction.getFunction());
                }
            });
            this.functionButtonsLayout.setConstraints(currentButton, this.functionButtonsC);
            this.functionsButtonsPanel.add(currentButton);
            if (++index % funtionRowLength == 0) {
                index = 0;
                this.functionButtonsC.gridwidth = 0;
                continue;
            }
            this.functionButtonsC.gridwidth = 1;
        }
        this.functionsButtonsPanel.revalidate();
        this.requestExpressionFocus();
    }

    private void validateExpression() {
        String expression = this.currentExpression.getText();
        if (expression != null) {
            if (expression.length() > 0) {
                this.parser.getParser().parseExpression(expression);
                if (this.parser.getParser().hasError()) {
                    this.validationIcon.setIcon(ERROR_ICON);
                    this.validationLabel.setText("<html><b>Error: </b>" + this.parser.getParser().getErrorInfo() + "</html>");
                    return;
                }
                this.validationIcon.setIcon(OK_ICON);
                this.validationLabel.setText("Expression is syntactically correct.");
            } else {
                this.validationIcon.setIcon(ERROR_ICON);
                this.validationLabel.setText("<html><b>Warning: </b>Please specify a valid expression.</html>");
            }
        } else {
            this.validationIcon.setIcon(ERROR_ICON);
            this.validationLabel.setText("<html><b>Warning: </b>Please specify a valid expression.</html>");
        }
    }

    public String getExpression() {
        return this.currentExpression.getText();
    }

    @Override
    protected String getInfoText() {
        return "<html><p>Please specify a valid expression in this dialog. Expressions can consist of numbers, text, constants (like Pi, e true, or false), functions, and variable names. Fractions in numbers are indicated by '.' and nominal text has to be quoted with double quotes. The possible functions can be selected by clicking on them below. Variables can be attribute names (select them by double clicking below or type in the name) or macros. Hence, used attribute names are not allowed to contain parentheses or other function symbols. All changes will result in a validation check. The icon on the right shows if the check was successful, a tool tip gives you more information.</p></html>";
    }

    static {
        OK_ICON = SwingTools.createIcon("16/ok.png");
        ERROR_ICON = SwingTools.createIcon("16/error.png");
    }
}

