/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class EnumerationPropertyTable
extends PropertyTable {
    private static final long serialVersionUID = -4547732551646588939L;
    private transient ParameterTypeEnumeration type;
    private transient Operator operator;
    private transient String keyToolTip;

    public EnumerationPropertyTable(ParameterTypeEnumeration type, List<String> valueList, Operator operator) {
        super(new String[]{type.getValueType().getKey(), type.getValueType().getKey()});
        String range;
        this.type = type;
        this.operator = operator;
        this.updateTableData(valueList.size());
        this.updateEditorsAndRenderers();
        int j = 0;
        for (String value : valueList) {
            this.getModel().setValueAt(value, j, 0);
            ++j;
        }
        ParameterType valueType = type.getValueType();
        StringBuffer toolTip = new StringBuffer(valueType.getDescription());
        if (!(valueType instanceof ParameterTypeCategory) && !(valueType instanceof ParameterTypeStringCategory) && (range = valueType.getRange()) != null && range.trim().length() > 0) {
            toolTip.append(" (");
            toolTip.append(valueType.getRange());
            toolTip.append(")");
        }
        this.keyToolTip = SwingTools.transformToolTipText(toolTip.toString());
    }

    public void addRow() {
        if (this.type.getValueType().getDefaultValue() != null) {
            this.getDefaultModel().addRow(new Object[]{this.type.getValueType().getDefaultValue()});
        } else {
            this.getDefaultModel().addRow(new Object[]{""});
        }
        this.updateEditorsAndRenderers();
        int lastIndex = this.getRowCount() - 1;
        Object value = this.type.getValueType().getDefaultValue();
        this.getModel().setValueAt(value, lastIndex, 0);
    }

    public void removeSelected() {
        int[] selectedRow = this.getSelectedRows();
        for (int i = selectedRow.length - 1; i >= 0; --i) {
            this.getDefaultModel().removeRow(selectedRow[i]);
        }
        this.getDefaultModel().fireTableStructureChanged();
    }

    @Override
    protected void updateTableData(int rows) {
        DefaultTableModel model = new DefaultTableModel(new String[]{this.type.getKey()}, rows);
        this.setModel(model);
    }

    public void getParameterList(List<String[]> list) {
        list.clear();
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            String firstString = null;
            Object firstObject = this.getModel().getValueAt(i, 0);
            if (firstObject instanceof String) {
                firstString = (String)firstObject;
            } else if (firstObject != null) {
                firstString = firstObject.toString();
            }
            String secondString = null;
            Object secondObject = this.getModel().getValueAt(i, 1);
            if (secondObject instanceof String) {
                secondString = (String)secondObject;
            } else if (secondObject != null) {
                secondString = secondObject.toString();
            }
            list.add(new String[]{firstString, secondString});
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int column = this.columnAtPoint(p);
        if (column == 0) {
            return this.keyToolTip;
        }
        return super.getToolTipText(e);
    }

    @Override
    public Operator getOperator(int row) {
        return this.operator;
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.type.getValueType();
    }

    @Override
    public ParameterType getKeyParameterType(int row) {
        return this.type;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void getParameterEnumeration(List<String> list) {
        list.clear();
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            Object firstObject = this.getModel().getValueAt(i, 0);
            if (firstObject instanceof String) {
                list.add((String)firstObject);
                continue;
            }
            if (firstObject == null) continue;
            list.add(firstObject.toString());
        }
    }
}

