/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.Process;
import com.rapidminer.gui.properties.PropertyDialog;
import com.rapidminer.gui.tools.ExtendedJList;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedListModel;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.meta.ParameterIteratingOperatorChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.ParameterTypeValue;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.value.ParameterValueGrid;
import com.rapidminer.parameter.value.ParameterValueList;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfigureParameterOptimizationDialog
extends PropertyDialog {
    private static final long serialVersionUID = 187660784321413390L;
    private static final String ADD_ICON_NAME = "add2.png";
    private static final String LEFT_ICON_NAME = "nav_left_green.png";
    private static final String RIGHT_ICON_NAME = "nav_right_green.png";
    private static final String UP_ICON_NAME = "nav_up_green.png";
    private static final String DOWN_ICON_NAME = "nav_down_green.png";
    private static Icon ADD_ICON = SwingTools.createIcon("16/add2.png");
    private static Icon LEFT_ICON = SwingTools.createIcon("16/nav_left_green.png");
    private static Icon RIGHT_ICON = SwingTools.createIcon("16/nav_right_green.png");
    private static Icon UP_ICON = SwingTools.createIcon("16/nav_up_green.png");
    private static Icon DOWN_ICON = SwingTools.createIcon("16/nav_down_green.png");
    private boolean ok = false;
    private final int mode;
    private ExtendedListModel operatorListModel;
    private ExtendedListModel parametersListModel;
    private ExtendedListModel selectedParametersListModel;
    private ExtendedJList operatorList;
    private ExtendedJList parametersList;
    private ExtendedJList selectedParametersList;
    private JLabel minValueJLabel;
    private JLabel maxValueJLabel;
    private JLabel stepsValueJLabel;
    private JLabel gridScaleValueJLabel;
    private JTextField minValueTextField;
    private JTextField maxValueTextField;
    private JTextField stepsValueTextField;
    private JComboBox gridScaleValueComboBox;
    private JList categoriesList;
    private JList selectedCategoriesList;
    private DefaultListModel categoriesListModel;
    private DefaultListModel selectedCategoriesListModel;
    private JTextField createValueTextField;
    private JButton createValueButton;
    private JButton addValueButton;
    private JButton removeValueButton;
    private JButton upListButton;
    private JButton downListButton;
    private JRadioButton choseGridRadioButton;
    private JRadioButton choseListRadioButton;
    private JLabel infoLabel;
    private final ConfigurationListener listener;
    private final Process process;
    private final LinkedHashMap<String, ParameterValues> parameterValuesMap;

    public ConfigureParameterOptimizationDialog(ParameterType type, ConfigurationListener listener) {
        super(type, "parameter_optimization");
        this.listener = listener;
        this.process = listener.getProcess();
        this.parameterValuesMap = new LinkedHashMap();
        this.layoutDefault((JComponent)this.createMainPanel(), this.createButtonPanel(), 3);
        ParameterIteratingOperatorChain parameterOperatorChain = (ParameterIteratingOperatorChain)listener;
        this.mode = parameterOperatorChain.getParameterValueMode();
        List<ParameterValues> readParameterValues = null;
        try {
            List<String[]> parameterValueList = ParameterTypeList.transformString2List(parameterOperatorChain.getParameters().getParameter("parameters"));
            readParameterValues = parameterOperatorChain.parseParameterValues(parameterValueList);
        }
        catch (Exception e) {
            parameterOperatorChain.logWarning(e.getMessage());
        }
        if (readParameterValues != null) {
            for (ParameterValues parameterValue : readParameterValues) {
                this.addParameter(parameterValue);
            }
        }
        this.updateInfoLabel();
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel selectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.operatorListModel = new ExtendedListModel();
        for (Operator op : ((OperatorChain)this.listener).getAllInnerOperators()) {
            String descriptionText = op.getOperatorDescription().getLongDescriptionHTML();
            if (descriptionText == null) {
                descriptionText = op.getOperatorDescription().getShortDescription();
            }
            StringBuffer toolTipText = new StringBuffer("<b>Description: </b>" + descriptionText);
            if (op != null) {
                toolTipText.append(Tools.getLineSeparator() + "<b>Input:</b> " + SwingTools.toHTMLString(op.getInputPorts()));
                toolTipText.append(Tools.getLineSeparator() + "<b>Output:</b> " + SwingTools.toHTMLString(op.getOutputPorts()));
            }
            this.operatorListModel.addElement(op, SwingTools.transformToolTipText(toolTipText.toString()));
        }
        this.operatorList = new ExtendedJList(this.operatorListModel);
        this.operatorList.setSelectionMode(0);
        this.operatorList.setLayoutOrientation(0);
        this.parametersListModel = new ExtendedListModel();
        this.parametersList = new ExtendedJList(this.parametersListModel);
        this.parametersList.setLayoutOrientation(0);
        this.operatorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ConfigureParameterOptimizationDialog.this.operatorList.getSelectedIndex();
                if (index != -1) {
                    Operator op = (Operator)ConfigureParameterOptimizationDialog.this.operatorList.getModel().getElementAt(index);
                    ConfigureParameterOptimizationDialog.this.updateParameterListModel(op);
                }
            }
        });
        this.selectedParametersListModel = new ExtendedListModel();
        this.selectedParametersList = new ExtendedJList(this.selectedParametersListModel);
        this.selectedParametersList.setLayoutOrientation(0);
        this.selectedParametersList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfigureParameterOptimizationDialog.this.showParameterValues((String)ConfigureParameterOptimizationDialog.this.selectedParametersList.getSelectedValue());
            }
        });
        JPanel parameterSelectionButtonsPanel = new JPanel(new BorderLayout());
        JButton addParameterButton = null;
        addParameterButton = RIGHT_ICON != null ? new JButton(RIGHT_ICON) : new JButton(">");
        addParameterButton.setToolTipText("Select parameters.");
        addParameterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.addSelectedParameters();
            }
        });
        JButton removeParameterButton = null;
        removeParameterButton = LEFT_ICON != null ? new JButton(LEFT_ICON) : new JButton("<");
        removeParameterButton.setToolTipText("Deselect parameters.");
        removeParameterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.removeSelectedParameters();
            }
        });
        parameterSelectionButtonsPanel.add((Component)addParameterButton, "North");
        parameterSelectionButtonsPanel.add((Component)removeParameterButton, "South");
        ExtendedJScrollPane operatorListScrollPane = new ExtendedJScrollPane(this.operatorList){
            private static final long serialVersionUID = 1103467036573935368L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getWidth() * 0.25), super.getPreferredSize().height);
            }
        };
        ExtendedJScrollPane parametersListScrollPane = new ExtendedJScrollPane(this.parametersList){
            private static final long serialVersionUID = 8474453689364798720L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getWidth() * 0.25), super.getPreferredSize().height);
            }
        };
        ExtendedJScrollPane selectedParametersListScrollPane = new ExtendedJScrollPane(this.selectedParametersList){
            private static final long serialVersionUID = -7089596032717082128L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getWidth() * 0.25), super.getPreferredSize().height);
            }
        };
        c.insets = new Insets(0, 0, 6, 6);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        operatorListScrollPane.setBorder(ConfigureParameterOptimizationDialog.createTitledBorder("Operators"));
        selectionPanel.add((Component)operatorListScrollPane, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        parametersListScrollPane.setBorder(ConfigureParameterOptimizationDialog.createTitledBorder("Parameters"));
        selectionPanel.add((Component)parametersListScrollPane, c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 0;
        selectionPanel.add((Component)parameterSelectionButtonsPanel, c);
        c.insets = new Insets(0, 0, 6, 0);
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        selectedParametersListScrollPane.setBorder(ConfigureParameterOptimizationDialog.createTitledBorder("Selected Parameters"));
        selectionPanel.add((Component)selectedParametersListScrollPane, c);
        panel.add((Component)selectionPanel, "North");
        JPanel gridPanel = new JPanel(new GridLayout(2, 4));
        ((GridLayout)gridPanel.getLayout()).setHgap(5);
        ((GridLayout)gridPanel.getLayout()).setVgap(0);
        gridPanel.setBorder(ConfigureParameterOptimizationDialog.createTitledBorder("Grid/Range"));
        this.minValueJLabel = new JLabel("Min");
        this.minValueJLabel.setEnabled(false);
        gridPanel.add(this.minValueJLabel);
        this.maxValueJLabel = new JLabel("Max");
        this.maxValueJLabel.setEnabled(false);
        gridPanel.add(this.maxValueJLabel);
        this.stepsValueJLabel = new JLabel("Steps");
        this.stepsValueJLabel.setEnabled(false);
        gridPanel.add(this.stepsValueJLabel);
        this.gridScaleValueJLabel = new JLabel("Scale");
        this.gridScaleValueJLabel.setEnabled(false);
        gridPanel.add(this.gridScaleValueJLabel);
        this.minValueTextField = new JFormattedTextField();
        this.minValueTextField.setText(Double.valueOf(0.0).toString());
        this.minValueTextField.setToolTipText("Minimum value of grid or range.");
        this.minValueTextField.setEnabled(false);
        this.minValueTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
            }
        });
        this.minValueTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues()) {
                    ConfigureParameterOptimizationDialog.this.minValueTextField.transferFocus();
                }
            }
        });
        gridPanel.add(this.minValueTextField);
        this.maxValueTextField = new JFormattedTextField();
        this.maxValueTextField.setText(Double.valueOf(0.0).toString());
        this.maxValueTextField.setToolTipText("Maximum value of grid or range.");
        this.maxValueTextField.setEnabled(false);
        this.maxValueTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
            }
        });
        this.maxValueTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues()) {
                    ConfigureParameterOptimizationDialog.this.maxValueTextField.transferFocus();
                }
            }
        });
        gridPanel.add(this.maxValueTextField);
        this.stepsValueTextField = new JFormattedTextField();
        this.stepsValueTextField.setText(Integer.valueOf(0).toString());
        this.stepsValueTextField.setToolTipText("Number of steps in grid.");
        this.stepsValueTextField.setEnabled(false);
        this.stepsValueTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
            }
        });
        this.stepsValueTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues()) {
                    ConfigureParameterOptimizationDialog.this.stepsValueTextField.transferFocus();
                }
            }
        });
        gridPanel.add(this.stepsValueTextField);
        this.gridScaleValueComboBox = this.mode == 0 ? new JComboBox<String>(ParameterValueGrid.SCALES) : new JComboBox();
        this.gridScaleValueComboBox.setToolTipText("Grid scheme.");
        this.gridScaleValueComboBox.setEnabled(false);
        this.gridScaleValueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
            }
        });
        gridPanel.add(this.gridScaleValueComboBox);
        JPanel listPanel = new JPanel(new GridBagLayout());
        listPanel.setBorder(ConfigureParameterOptimizationDialog.createTitledBorder("Value List"));
        this.categoriesListModel = new DefaultListModel();
        this.selectedCategoriesListModel = new DefaultListModel();
        this.createValueTextField = new JTextField();
        this.createValueTextField.setToolTipText("Type in a new value here.");
        this.createValueTextField.setEnabled(false);
        this.createValueTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.createListValue();
            }
        });
        c.insets = new Insets(6, 0, 6, 6);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.475;
        c.weighty = 0.0;
        c.fill = 1;
        listPanel.add((Component)this.createValueTextField, c);
        this.categoriesList = new JList(this.categoriesListModel);
        this.categoriesList.setToolTipText("Available (or predefined) values.");
        this.categoriesList.setEnabled(false);
        c.insets = new Insets(0, 0, 0, 6);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.475;
        c.weighty = 1.0;
        c.fill = 1;
        ExtendedJScrollPane categoriesListPane = new ExtendedJScrollPane(this.categoriesList){
            private static final long serialVersionUID = 6534315233269693255L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getWidth() * 0.5), super.getPreferredSize().height);
            }
        };
        categoriesListPane.setBorder(ConfigureParameterOptimizationDialog.createBorder());
        listPanel.add((Component)categoriesListPane, c);
        this.createValueButton = ADD_ICON != null ? new JButton(ADD_ICON) : new JButton("+");
        this.createValueButton.setToolTipText("Add a new value.");
        this.createValueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.createListValue();
            }
        });
        this.createValueButton.setEnabled(false);
        c.insets = new Insets(6, 0, 6, 6);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        listPanel.add((Component)this.createValueButton, c);
        JPanel valueSelectionButtonsPanel = new JPanel(new BorderLayout());
        this.addValueButton = RIGHT_ICON != null ? new JButton(RIGHT_ICON) : new JButton(">");
        this.addValueButton.setToolTipText("Select value from list of available values.");
        this.addValueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedParameter = (String)ConfigureParameterOptimizationDialog.this.selectedParametersListModel.get(ConfigureParameterOptimizationDialog.this.selectedParametersList.getLeadSelectionIndex());
                Object[] selectedValues = ConfigureParameterOptimizationDialog.this.categoriesList.getSelectedValues();
                for (int i = 0; i < selectedValues.length; ++i) {
                    ConfigureParameterOptimizationDialog.this.categoriesListModel.removeElement(selectedValues[i]);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.addElement(selectedValues[i]);
                    ParameterValues parameterValue = (ParameterValues)ConfigureParameterOptimizationDialog.this.parameterValuesMap.get(selectedParameter);
                    if (!(parameterValue instanceof ParameterValueList)) continue;
                    ((ParameterValueList)parameterValue).add((String)selectedValues[i]);
                }
                ConfigureParameterOptimizationDialog.this.updateInfoLabel();
            }
        });
        this.addValueButton.setEnabled(false);
        this.removeValueButton = LEFT_ICON != null ? new JButton(LEFT_ICON) : new JButton("<");
        this.removeValueButton.setToolTipText("Remove value from selection.");
        this.removeValueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedParameter = (String)ConfigureParameterOptimizationDialog.this.selectedParametersListModel.get(ConfigureParameterOptimizationDialog.this.selectedParametersList.getLeadSelectionIndex());
                Object[] selectedValues = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedValues();
                for (int i = 0; i < selectedValues.length; ++i) {
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.removeElement(selectedValues[i]);
                    ParameterValues parameterValue = (ParameterValues)ConfigureParameterOptimizationDialog.this.parameterValuesMap.get(selectedParameter);
                    if (!(parameterValue instanceof ParameterValueList) || !((ParameterValueList)parameterValue).contains((String)selectedValues[i])) continue;
                    ConfigureParameterOptimizationDialog.this.categoriesListModel.addElement(selectedValues[i]);
                    ((ParameterValueList)parameterValue).remove((String)selectedValues[i]);
                }
                ConfigureParameterOptimizationDialog.this.updateInfoLabel();
            }
        });
        this.removeValueButton.setEnabled(false);
        valueSelectionButtonsPanel.add((Component)this.addValueButton, "Center");
        valueSelectionButtonsPanel.add((Component)this.removeValueButton, "South");
        c.insets = new Insets(0, 0, 0, 6);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridheight = 2;
        c.fill = 0;
        listPanel.add((Component)valueSelectionButtonsPanel, c);
        this.selectedCategoriesList = new JList(this.selectedCategoriesListModel);
        this.selectedCategoriesList.setToolTipText("Selected values.");
        this.selectedCategoriesList.setEnabled(false);
        c.insets = new Insets(6, 0, 0, 6);
        c.gridx = 2;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 0.475;
        c.fill = 1;
        ExtendedJScrollPane selectedCategoriesListPane = new ExtendedJScrollPane(this.selectedCategoriesList){
            private static final long serialVersionUID = 4901808754076811895L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getWidth() * 0.5), super.getPreferredSize().height);
            }
        };
        selectedCategoriesListPane.setBorder(ConfigureParameterOptimizationDialog.createBorder());
        listPanel.add((Component)selectedCategoriesListPane, c);
        JPanel valueMovingButtonsPanel = new JPanel(new BorderLayout());
        this.upListButton = UP_ICON != null ? new JButton(UP_ICON) : new JButton("Up");
        this.upListButton.setToolTipText("Move the selected value up in the list.");
        this.upListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex;
                Object selectedValue;
                ParameterValues parameterValue;
                String selectedParameter = (String)ConfigureParameterOptimizationDialog.this.selectedParametersListModel.get(ConfigureParameterOptimizationDialog.this.selectedParametersList.getLeadSelectionIndex());
                int[] selectedIndices = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedIndices();
                if (selectedIndices.length == 1 && (parameterValue = (ParameterValues)ConfigureParameterOptimizationDialog.this.parameterValuesMap.get(selectedParameter)) instanceof ParameterValueList && ((ParameterValueList)parameterValue).contains((String)(selectedValue = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedValue())) && (selectedIndex = selectedIndices[0]) >= 1) {
                    parameterValue.move(selectedIndex, -1);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.remove(selectedIndex);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.add(selectedIndex - 1, selectedValue);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesList.setSelectedIndex(selectedIndex - 1);
                }
            }
        });
        this.upListButton.setEnabled(false);
        this.downListButton = DOWN_ICON != null ? new JButton(DOWN_ICON) : new JButton("Down");
        this.downListButton.setToolTipText("Move the selected value down in the list.");
        this.downListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex;
                Object selectedValue;
                ParameterValues parameterValue;
                String selectedParameter = (String)ConfigureParameterOptimizationDialog.this.selectedParametersListModel.get(ConfigureParameterOptimizationDialog.this.selectedParametersList.getLeadSelectionIndex());
                int[] selectedIndices = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedIndices();
                if (selectedIndices.length == 1 && (parameterValue = (ParameterValues)ConfigureParameterOptimizationDialog.this.parameterValuesMap.get(selectedParameter)) instanceof ParameterValueList && ((ParameterValueList)parameterValue).contains((String)(selectedValue = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedValue())) && (selectedIndex = selectedIndices[0]) < ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.size() - 1) {
                    parameterValue.move(selectedIndex, 1);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.remove(selectedIndex);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.add(selectedIndex + 1, selectedValue);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesList.setSelectedIndex(selectedIndex + 1);
                }
            }
        });
        this.downListButton.setEnabled(false);
        valueMovingButtonsPanel.add((Component)this.upListButton, "Center");
        valueMovingButtonsPanel.add((Component)this.downListButton, "South");
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 3;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridheight = 2;
        c.fill = 0;
        listPanel.add((Component)valueMovingButtonsPanel, c);
        listPanel.setEnabled(false);
        JPanel valuePanel = new JPanel(new BorderLayout());
        valuePanel.add((Component)gridPanel, "North");
        valuePanel.add((Component)listPanel, "Center");
        panel.add((Component)valuePanel, "Center");
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel radioButtonPanel = new JPanel(new FlowLayout(0));
        this.choseGridRadioButton = new JRadioButton("Grid", true);
        this.choseGridRadioButton.setToolTipText("Use a regular grid for numerical parameters.");
        this.choseGridRadioButton.setEnabled(false);
        this.choseGridRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureParameterOptimizationDialog.this.choseGridRadioButton.isSelected()) {
                    ConfigureParameterOptimizationDialog.this.choseGridRadioButton.setSelected(true);
                    ConfigureParameterOptimizationDialog.this.choseListRadioButton.setSelected(false);
                    ConfigureParameterOptimizationDialog.this.switchToGrid();
                }
            }
        });
        radioButtonPanel.add(this.choseGridRadioButton);
        this.choseListRadioButton = new JRadioButton("List", false);
        this.choseListRadioButton.setToolTipText("Use a list of single values for numerical parameters.");
        this.choseListRadioButton.setEnabled(false);
        this.choseListRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureParameterOptimizationDialog.this.choseListRadioButton.isSelected()) {
                    ConfigureParameterOptimizationDialog.this.choseListRadioButton.setSelected(true);
                    ConfigureParameterOptimizationDialog.this.choseGridRadioButton.setSelected(false);
                    ConfigureParameterOptimizationDialog.this.switchToList();
                }
            }
        });
        radioButtonPanel.add(this.choseListRadioButton);
        JPanel infoPanel = new JPanel(new FlowLayout(1));
        this.infoLabel = new JLabel();
        infoPanel.add(this.infoLabel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(new ResourceAction("ok", new Object[0]){
            private static final long serialVersionUID = -5102786702723664410L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(new ResourceAction("cancel", new Object[0]){
            private static final long serialVersionUID = 3400772620633105463L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)radioButtonPanel, "West");
        bottomPanel.add((Component)infoPanel, "Center");
        bottomPanel.add((Component)buttonPanel, "East");
        return bottomPanel;
    }

    private void updateInfoLabel() {
        int size = this.parameterValuesMap.size();
        int combinations = 1;
        try {
            if (this.mode == 0) {
                for (ParameterValues parameterValues : this.parameterValuesMap.values()) {
                    int values = parameterValues.getNumberOfValues();
                    combinations *= values == 0 ? 1 : values;
                }
                this.infoLabel.setText(size + " parameter" + (size > 1 ? "s" : "") + " / " + combinations + " combinations selected");
            } else {
                this.infoLabel.setText(size + " parameter" + (size > 1 ? "s" : "") + " selected");
            }
        }
        catch (NumberFormatException e) {
            this.infoLabel.setText(size + " parameter" + (size > 1 ? "s" : "") + " selected");
        }
    }

    private void createListValue() {
        String selectedParameter = (String)this.selectedParametersListModel.get(this.selectedParametersList.getLeadSelectionIndex());
        String createdValue = this.createValueTextField.getText();
        if (createdValue.equals("")) {
            return;
        }
        if (this.selectedCategoriesListModel.contains(createdValue)) {
            return;
        }
        this.selectedCategoriesListModel.addElement(createdValue);
        ParameterValues parameterValue = this.parameterValuesMap.get(selectedParameter);
        if (parameterValue instanceof ParameterValueList) {
            ((ParameterValueList)parameterValue).add(createdValue);
        }
        if (this.categoriesListModel.contains(createdValue)) {
            this.categoriesListModel.removeElement(createdValue);
        }
        this.createValueTextField.setText("");
        this.updateInfoLabel();
    }

    private void switchToGrid() {
        ParameterValues oldParameterValues;
        String key = (String)this.selectedParametersList.getSelectedValue();
        if (key != null && (oldParameterValues = this.parameterValuesMap.get(key)) instanceof ParameterValueList) {
            ParameterValues newParameterValues = this.createNumericalParameterValues(oldParameterValues.getOperator(), oldParameterValues.getParameterType());
            this.parameterValuesMap.put(key, newParameterValues);
            this.fillComponents(newParameterValues);
        }
        this.minValueJLabel.setEnabled(true);
        this.maxValueJLabel.setEnabled(true);
        this.stepsValueJLabel.setEnabled(true);
        this.gridScaleValueJLabel.setEnabled(true);
        this.minValueTextField.setEnabled(true);
        this.maxValueTextField.setEnabled(true);
        this.stepsValueTextField.setEnabled(true);
        this.gridScaleValueComboBox.setEnabled(true);
        this.categoriesList.setEnabled(false);
        this.selectedCategoriesList.setEnabled(false);
        this.addValueButton.setEnabled(false);
        this.removeValueButton.setEnabled(false);
        this.createValueButton.setEnabled(false);
        this.createValueTextField.setEnabled(false);
        this.upListButton.setEnabled(false);
        this.downListButton.setEnabled(false);
        this.updateInfoLabel();
    }

    private void switchToList() {
        ParameterValues oldParameterValues;
        String key = (String)this.selectedParametersList.getSelectedValue();
        if (key != null && (oldParameterValues = this.parameterValuesMap.get(key)) instanceof ParameterValueGrid) {
            ParameterValueList newParameterValues = new ParameterValueList(oldParameterValues.getOperator(), oldParameterValues.getParameterType());
            this.parameterValuesMap.put(key, newParameterValues);
            this.fillComponents(newParameterValues);
        }
        this.minValueJLabel.setEnabled(false);
        this.maxValueJLabel.setEnabled(false);
        this.stepsValueJLabel.setEnabled(false);
        this.gridScaleValueJLabel.setEnabled(false);
        this.minValueTextField.setEnabled(false);
        this.maxValueTextField.setEnabled(false);
        this.stepsValueTextField.setEnabled(false);
        this.gridScaleValueComboBox.setEnabled(false);
        this.categoriesList.setEnabled(true);
        this.selectedCategoriesList.setEnabled(true);
        this.addValueButton.setEnabled(true);
        this.removeValueButton.setEnabled(true);
        this.createValueButton.setEnabled(true);
        this.createValueTextField.setEnabled(true);
        this.upListButton.setEnabled(true);
        this.downListButton.setEnabled(true);
        this.updateInfoLabel();
    }

    private void updateParameterListModel(Operator operator) {
        this.parametersListModel.removeAllElements();
        Collection<ParameterType> parameters = operator.getParameters().getParameterTypes();
        for (ParameterType parameter : parameters) {
            if (this.mode == 1 && !(parameter instanceof ParameterTypeNumber) || this.parameterValuesMap.containsKey(operator.getName() + "." + parameter.getKey())) continue;
            this.parametersListModel.addElement(parameter.getKey(), parameter.getDescription());
            if (parameter.isNumerical() || parameter instanceof ParameterTypeCategory || parameter instanceof ParameterTypeStringCategory || parameter instanceof ParameterTypeString || parameter instanceof ParameterTypeBoolean || parameter instanceof ParameterTypeFile) continue;
            this.parametersListModel.setEnabled(parameter.getKey(), false);
        }
    }

    private void addSelectedParameters() {
        Object[] parameterKeys = this.parametersList.getSelectedValues();
        Operator operator = (Operator)this.operatorList.getSelectedValue();
        for (int i = 0; i < parameterKeys.length; ++i) {
            String parameterKey = (String)parameterKeys[i];
            ParameterType type = operator.getParameterType(parameterKey);
            ParameterValues parameterValue = null;
            if (type.isNumerical()) {
                parameterValue = this.createNumericalParameterValues(operator, type);
            } else if (type instanceof ParameterTypeCategory || type instanceof ParameterTypeStringCategory || type instanceof ParameterTypeString || type instanceof ParameterTypeBoolean || type instanceof ParameterTypeFile) {
                parameterValue = new ParameterValueList(operator, type, this.getDefaultListParameterValues(type));
            }
            if (parameterValue == null) continue;
            this.addParameter(parameterValue);
        }
        this.updateInfoLabel();
    }

    private void addParameter(ParameterValues parameterValue) {
        String key = parameterValue.getKey();
        this.parameterValuesMap.put(key, parameterValue);
        this.selectedParametersListModel.addElement(key, parameterValue.getParameterType().getDescription());
        this.parametersListModel.removeElement(parameterValue.getParameterType().getKey());
    }

    private void removeSelectedParameters() {
        Object[] selectedParameters = this.selectedParametersList.getSelectedValues();
        for (int i = 0; i < selectedParameters.length; ++i) {
            Operator op;
            String selected = (String)selectedParameters[i];
            String operatorName = ParameterTypeTupel.transformString2Tupel(selected)[0];
            this.selectedParametersListModel.removeElement(selectedParameters[i]);
            this.parameterValuesMap.remove(selectedParameters[i]);
            int index = this.operatorList.getSelectedIndex();
            if (index == -1 || (op = (Operator)this.operatorList.getModel().getElementAt(index)) != this.process.getOperator(operatorName)) continue;
            this.updateParameterListModel(op);
        }
        this.updateInfoLabel();
    }

    private void enableComponents(ParameterValues parameterValue) {
        this.minValueJLabel.setEnabled(false);
        this.maxValueJLabel.setEnabled(false);
        this.stepsValueJLabel.setEnabled(false);
        this.gridScaleValueJLabel.setEnabled(false);
        this.minValueTextField.setEnabled(false);
        this.maxValueTextField.setEnabled(false);
        this.stepsValueTextField.setEnabled(false);
        this.gridScaleValueComboBox.setEnabled(false);
        this.categoriesList.setEnabled(false);
        this.selectedCategoriesList.setEnabled(false);
        this.addValueButton.setEnabled(false);
        this.removeValueButton.setEnabled(false);
        this.createValueButton.setEnabled(false);
        this.createValueTextField.setEnabled(false);
        this.upListButton.setEnabled(false);
        this.downListButton.setEnabled(false);
        this.choseGridRadioButton.setEnabled(false);
        this.choseListRadioButton.setEnabled(false);
        if (parameterValue != null) {
            ParameterType type = parameterValue.getParameterType();
            if (type instanceof ParameterTypeBoolean || type instanceof ParameterTypeCategory) {
                this.categoriesList.setEnabled(true);
                this.selectedCategoriesList.setEnabled(true);
                this.addValueButton.setEnabled(true);
                this.removeValueButton.setEnabled(true);
                this.upListButton.setEnabled(true);
                this.downListButton.setEnabled(true);
            } else if (type instanceof ParameterTypeNumber) {
                if (!(parameterValue instanceof ParameterValueRange)) {
                    this.choseGridRadioButton.setEnabled(true);
                    this.choseListRadioButton.setEnabled(true);
                }
                if (parameterValue instanceof ParameterValueList) {
                    this.categoriesList.setEnabled(true);
                    this.selectedCategoriesList.setEnabled(true);
                    this.addValueButton.setEnabled(true);
                    this.removeValueButton.setEnabled(true);
                    this.createValueTextField.setEnabled(true);
                    this.createValueButton.setEnabled(true);
                    this.choseGridRadioButton.setSelected(false);
                    this.choseListRadioButton.setSelected(true);
                    this.upListButton.setEnabled(true);
                    this.downListButton.setEnabled(true);
                } else {
                    this.minValueJLabel.setEnabled(true);
                    this.maxValueJLabel.setEnabled(true);
                    this.minValueTextField.setEnabled(true);
                    this.maxValueTextField.setEnabled(true);
                    if (parameterValue instanceof ParameterValueGrid) {
                        this.stepsValueJLabel.setEnabled(true);
                        this.gridScaleValueJLabel.setEnabled(true);
                        this.stepsValueTextField.setEnabled(true);
                        this.gridScaleValueComboBox.setEnabled(true);
                        this.choseGridRadioButton.setSelected(true);
                        this.choseListRadioButton.setSelected(false);
                    }
                }
            } else if (type instanceof ParameterTypeString || type instanceof ParameterTypeStringCategory || type instanceof ParameterTypeValue || type instanceof ParameterTypeFile) {
                this.categoriesList.setEnabled(true);
                this.selectedCategoriesList.setEnabled(true);
                this.createValueButton.setEnabled(true);
                this.createValueTextField.setEnabled(true);
                this.addValueButton.setEnabled(true);
                this.removeValueButton.setEnabled(true);
                this.upListButton.setEnabled(true);
                this.downListButton.setEnabled(true);
            }
        }
    }

    private void showGridValues(ParameterValueGrid parameterValueGrid) {
        this.selectedCategoriesListModel.removeAllElements();
        try {
            double[] gridValues = parameterValueGrid.getValues();
            for (int i = 0; i < gridValues.length; ++i) {
                this.selectedCategoriesListModel.addElement(Tools.formatIntegerIfPossible(gridValues[i]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void fillComponents(ParameterValues parameterValue) {
        this.categoriesListModel.removeAllElements();
        this.selectedCategoriesListModel.removeAllElements();
        if (parameterValue instanceof ParameterValueRange) {
            ParameterValueRange parameterValueRange = (ParameterValueRange)parameterValue;
            this.minValueTextField.setText(parameterValueRange.getMin());
            this.maxValueTextField.setText(parameterValueRange.getMax());
        } else if (parameterValue instanceof ParameterValueGrid) {
            ParameterValueGrid parameterValueGrid = (ParameterValueGrid)parameterValue;
            this.minValueTextField.setText(parameterValueGrid.getMin());
            this.maxValueTextField.setText(parameterValueGrid.getMax());
            this.stepsValueTextField.setText(parameterValueGrid.getSteps());
            this.gridScaleValueComboBox.setSelectedIndex(parameterValueGrid.getScale());
            this.showGridValues(parameterValueGrid);
        } else if (parameterValue instanceof ParameterValueList) {
            ParameterValueList parameterValueList = (ParameterValueList)parameterValue;
            ParameterType type = parameterValueList.getParameterType();
            for (Object value : parameterValueList) {
                this.selectedCategoriesListModel.addElement(value);
            }
            String[] categories = this.getDefaultListParameterValues(type);
            if (categories != null) {
                for (int i = 0; i < categories.length; ++i) {
                    if (parameterValueList.contains(categories[i])) continue;
                    this.categoriesListModel.addElement(categories[i]);
                }
            }
        }
    }

    private void showParameterValues(String key) {
        if (key == null) {
            this.enableComponents(null);
            return;
        }
        ParameterValues parameterValues = this.parameterValuesMap.get(key);
        this.fillComponents(parameterValues);
        this.enableComponents(parameterValues);
    }

    private boolean updateSelectedNumericalParameterValues() {
        int index = this.selectedParametersList.getSelectedIndex();
        if (index == -1) {
            this.enableComponents(null);
            return false;
        }
        String key = (String)this.selectedParametersListModel.get(index);
        ParameterValues parameterValues = this.parameterValuesMap.get(key);
        if (parameterValues != null) {
            String value;
            if (parameterValues instanceof ParameterValueGrid) {
                ParameterValueGrid parameterValueGrid = (ParameterValueGrid)parameterValues;
                value = this.minValueTextField.getText();
                if (!ParameterValues.isValidNumericalParameter(value)) {
                    this.minValueTextField.setText(parameterValueGrid.getMin());
                    SwingTools.showVerySimpleErrorMessage("parameter_grid", "minimum value", value);
                    return false;
                }
                parameterValueGrid.setMin(value);
                value = this.maxValueTextField.getText();
                if (!ParameterValues.isValidNumericalParameter(value)) {
                    this.maxValueTextField.setText(parameterValueGrid.getMax());
                    SwingTools.showVerySimpleErrorMessage("parameter_grid", "maximum value", value);
                    return false;
                }
                parameterValueGrid.setMax(value);
                value = this.stepsValueTextField.getText();
                if (!ParameterValues.isValidNumericalParameter(value)) {
                    this.stepsValueTextField.setText(parameterValueGrid.getSteps());
                    SwingTools.showVerySimpleErrorMessage("parameter_grid", "number of steps", value);
                    return false;
                }
                parameterValueGrid.setSteps(value);
                parameterValueGrid.setScale(this.gridScaleValueComboBox.getSelectedIndex());
                this.showGridValues(parameterValueGrid);
            }
            if (parameterValues instanceof ParameterValueRange) {
                ParameterValueRange parameterValueRange = (ParameterValueRange)parameterValues;
                value = this.minValueTextField.getText();
                if (!ParameterValues.isValidNumericalParameter(value)) {
                    this.minValueTextField.setText(parameterValueRange.getMin());
                    SwingTools.showVerySimpleErrorMessage("parameter_range", "minimum value", value);
                    return false;
                }
                parameterValueRange.setMin(value);
                value = this.maxValueTextField.getText();
                if (ParameterValues.isValidNumericalParameter(value)) {
                    parameterValueRange.setMax(value);
                } else {
                    this.maxValueTextField.setText(parameterValueRange.getMax());
                    SwingTools.showVerySimpleErrorMessage("parameter_range", "maximum value", value);
                    return false;
                }
            }
        }
        this.updateInfoLabel();
        return true;
    }

    private ParameterValues createNumericalParameterValues(Operator operator, ParameterType type) {
        double min = ((ParameterTypeNumber)type).getMinValue();
        double max = ((ParameterTypeNumber)type).getMaxValue();
        if (this.mode == 0) {
            return new ParameterValueGrid(operator, type, Double.toString(min), Double.toString(max));
        }
        return new ParameterValueRange(operator, type, Double.toString(min), Double.toString(max));
    }

    private String[] getDefaultListParameterValues(ParameterType type) {
        if (type instanceof ParameterTypeCategory) {
            return ((ParameterTypeCategory)type).getValues();
        }
        if (type instanceof ParameterTypeStringCategory) {
            return ((ParameterTypeStringCategory)type).getValues();
        }
        if (type instanceof ParameterTypeBoolean) {
            return new String[]{"true", "false"};
        }
        return new String[0];
    }

    @Override
    protected void ok() {
        this.ok = true;
        LinkedList<String[]> parameterList = new LinkedList<String[]>();
        for (String key : this.parameterValuesMap.keySet()) {
            String value = this.parameterValuesMap.get(key).getValuesString();
            parameterList.add(new String[]{key, value});
        }
        Parameters parameters = this.listener.getParameters();
        parameters.setParameter("parameters", ParameterTypeList.transformList2String(parameterList));
        this.listener.setParameters(parameters);
        this.dispose();
    }

    @Override
    protected void cancel() {
        this.ok = false;
        this.dispose();
    }

    @Override
    public boolean isOk() {
        return this.ok;
    }
}

