/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractSpinnerModel;

public class CompatibilityLevelSpinnerModel
extends AbstractSpinnerModel {
    private int index = 0;
    private Operator operator;
    private List<OperatorVersion> versions = new LinkedList<OperatorVersion>();

    protected void setOperator(Operator operator) {
        this.operator = operator;
        this.versions = new LinkedList<OperatorVersion>(Arrays.asList(operator.getIncompatibleVersionChanges()));
        OperatorVersion latest = OperatorVersion.getLatestVersion(operator.getOperatorDescription());
        if (!this.versions.contains(latest)) {
            this.versions.add(latest);
        }
        this.setValue(operator.getCompatibilityLevel());
    }

    @Override
    public Object getNextValue() {
        if (this.index + 1 >= this.versions.size()) {
            return null;
        }
        return this.versions.get(this.index + 1);
    }

    @Override
    public Object getPreviousValue() {
        if (this.index <= 0) {
            return null;
        }
        return this.versions.get(this.index - 1);
    }

    @Override
    public Object getValue() {
        if (this.operator != null) {
            return this.operator.getCompatibilityLevel();
        }
        return "-------";
    }

    @Override
    public void setValue(Object value) {
        if (this.operator != null) {
            if (value instanceof String) {
                value = new OperatorVersion((String)value);
            }
            if (value == null) {
                value = OperatorVersion.getLatestVersion(this.operator.getOperatorDescription());
            }
            this.operator.setCompatibilityLevel((OperatorVersion)value);
            this.index = this.versions.indexOf(value);
            if (this.index == -1) {
                this.versions.add((OperatorVersion)value);
                Collections.sort(this.versions);
                this.index = this.versions.indexOf(value);
            }
            this.fireStateChanged();
        }
    }
}

