/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;

public class BasicPropertyTable
extends PropertyTable {
    private static final long serialVersionUID = -2054750632363559123L;
    private ParameterType[] shownParameterTypes = new ParameterType[0];
    private Parameters parameters = new Parameters();

    public BasicPropertyTable() {
        this.setModel(new BasicPropertyModel());
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
        this.updateParameterTypes();
    }

    private void updateParameterTypes() {
        LinkedList<ParameterType> viewableList = new LinkedList<ParameterType>();
        for (String key : this.parameters) {
            ParameterType type = this.parameters.getParameterType(key);
            if (type.isHidden()) continue;
            viewableList.add(type);
        }
        this.shownParameterTypes = new ParameterType[viewableList.size()];
        viewableList.toArray(this.shownParameterTypes);
        this.setModel(new BasicPropertyModel());
        this.updateEditorsAndRenderers();
    }

    public void setValue(String key, Object value) {
        this.parameters.setParameter(key, (String)value);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    @Override
    public Operator getOperator(int row) {
        return null;
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.shownParameterTypes[row];
    }

    public void clearParameterTypes() {
        this.parameters = new Parameters();
        this.updateParameterTypes();
    }

    public void setValue(int row, Object value) {
        this.getModel().setValueAt(value, row, 1);
    }

    private class BasicPropertyModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6246875779676802335L;

        private BasicPropertyModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return BasicPropertyTable.this.shownParameterTypes.length;
        }

        @Override
        public String getColumnName(int index) {
            if (index == 0) {
                return "Key";
            }
            return "Value";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String key = BasicPropertyTable.this.getParameterType(rowIndex).getKey();
            if (columnIndex == 0) {
                return key;
            }
            try {
                return BasicPropertyTable.this.parameters.getParameter(key);
            }
            catch (UndefinedParameterError e) {
                return null;
            }
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 1) {
                String key = BasicPropertyTable.this.getParameterType(row).getKey();
                BasicPropertyTable.this.parameters.setParameter(key, (String)value);
            }
        }
    }
}

