/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyDialog;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.FilterTextField;
import com.rapidminer.gui.tools.FilterableListModel;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;

public class AttributesPropertyDialog
extends PropertyDialog {
    private static final long serialVersionUID = 5396725165122306231L;
    private final ArrayList<String> items;
    private final ArrayList<String> selectedItems;
    private final FilterTextField itemSearchField;
    private final FilterTextField selectedItemSearchField;
    private final FilterableListModel itemListModel;
    private final FilterableListModel selectedItemListModel;
    private final JList itemList;
    private final JList selectedItemList;
    private final Action selectAttributesAction = new ResourceAction(true, "attributes_select", new Object[0]){
        private static final long serialVersionUID = -3046621278306353077L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices = AttributesPropertyDialog.this.itemList.getSelectedIndices();
            AttributesPropertyDialog.this.itemList.setSelectedIndices(new int[0]);
            for (int i = indices.length - 1; i >= 0; --i) {
                String item = AttributesPropertyDialog.this.itemListModel.getElementAt(indices[i]).toString();
                AttributesPropertyDialog.this.selectedItemListModel.addElement(item);
                AttributesPropertyDialog.this.itemListModel.removeElementAt(indices[i]);
                AttributesPropertyDialog.this.selectedItems.add(item);
                AttributesPropertyDialog.this.items.remove(item);
            }
        }
    };
    private final Action deselectAttributesAction = new ResourceAction(true, "attributes_deselect", new Object[0]){
        private static final long serialVersionUID = -3046621278306353077L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices = AttributesPropertyDialog.this.selectedItemList.getSelectedIndices();
            AttributesPropertyDialog.this.selectedItemList.setSelectedIndices(new int[0]);
            for (int i = indices.length - 1; i >= 0; --i) {
                String item = AttributesPropertyDialog.this.selectedItemListModel.getElementAt(indices[i]).toString();
                AttributesPropertyDialog.this.itemListModel.addElement(item);
                AttributesPropertyDialog.this.selectedItemListModel.removeElementAt(indices[i]);
                AttributesPropertyDialog.this.items.add(item);
                AttributesPropertyDialog.this.selectedItems.remove(item);
            }
        }
    };

    public AttributesPropertyDialog(ParameterTypeAttributes type, Collection<String> preselectedItems) {
        super(type, "attributes");
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.items = new ArrayList();
        this.selectedItems = new ArrayList();
        this.itemListModel = new FilterableListModel();
        this.selectedItemListModel = new FilterableListModel();
        System.err.println(preselectedItems.size());
        for (String item : type.getAttributeNames()) {
            if (!preselectedItems.contains(item)) {
                this.items.add(item);
                this.itemListModel.addElement(item);
                continue;
            }
            this.selectedItems.add(item);
            this.selectedItemListModel.addElement(item);
        }
        for (String item : preselectedItems) {
            if (type.getAttributeNames().contains(item)) continue;
            this.selectedItems.add(item);
            this.selectedItemListModel.addElement(item);
        }
        this.itemSearchField = new FilterTextField();
        this.itemSearchField.addFilterListener(this.itemListModel);
        JButton itemSearchFieldClearButton = new JButton(new ResourceAction(true, "attributes.clear", new Object[0]){
            private static final long serialVersionUID = -3046621278306353077L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesPropertyDialog.this.itemSearchField.clearFilter();
            }
        });
        JPanel itemSearchFieldPanel = new JPanel(new GridBagLayout());
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        itemSearchFieldPanel.add((Component)this.itemSearchField, c);
        c.gridx = 1;
        c.weightx = 0.0;
        itemSearchFieldPanel.add((Component)itemSearchFieldClearButton, c);
        this.itemList = new JList(this.itemListModel);
        this.itemList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AttributesPropertyDialog.this.selectAttributesAction.actionPerformed(null);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        ExtendedJScrollPane itemListPane = new ExtendedJScrollPane(this.itemList);
        itemListPane.setBorder(AttributesPropertyDialog.createBorder());
        JPanel itemListPanel = new JPanel(new GridBagLayout());
        c.insets = new Insets(4, 4, 4, 4);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        itemListPanel.add((Component)itemSearchFieldPanel, c);
        c.gridy = 1;
        c.weighty = 1.0;
        itemListPanel.add((Component)itemListPane, c);
        itemListPanel.setBorder(AttributesPropertyDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".attributes.border", new Object[0])));
        this.selectedItemSearchField = new FilterTextField();
        this.selectedItemSearchField.addFilterListener(this.selectedItemListModel);
        JButton selectedItemSearchFieldClearButton = new JButton(new ResourceAction(true, "attributes.clear", new Object[0]){
            private static final long serialVersionUID = -3046621278306353032L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesPropertyDialog.this.selectedItemSearchField.clearFilter();
            }
        });
        JPanel selectedItemSearchFieldPanel = new JPanel(new GridBagLayout());
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        selectedItemSearchFieldPanel.add((Component)this.selectedItemSearchField, c);
        JButton addValueButton = new JButton(new ResourceAction(true, "attributes.add", new Object[0]){
            private static final long serialVersionUID = 41667438431831572L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String item = AttributesPropertyDialog.this.selectedItemSearchField.getText();
                if (AttributesPropertyDialog.this.selectedItems.contains(item)) {
                    AttributesPropertyDialog.this.selectedItemSearchField.clearFilter();
                    return;
                }
                if (AttributesPropertyDialog.this.items.contains(item)) {
                    AttributesPropertyDialog.this.selectedItemListModel.addElement(item);
                    AttributesPropertyDialog.this.itemListModel.removeElement(item);
                    AttributesPropertyDialog.this.selectedItems.add(item);
                    AttributesPropertyDialog.this.items.remove(item);
                    AttributesPropertyDialog.this.selectedItemSearchField.clearFilter();
                    return;
                }
                AttributesPropertyDialog.this.selectedItems.add(item);
                AttributesPropertyDialog.this.selectedItemListModel.addElement(item);
                AttributesPropertyDialog.this.selectedItemSearchField.clearFilter();
            }
        });
        c.gridx = 1;
        c.weightx = 0.0;
        selectedItemSearchFieldPanel.add((Component)addValueButton, c);
        c.gridx = 2;
        c.weightx = 0.0;
        selectedItemSearchFieldPanel.add((Component)selectedItemSearchFieldClearButton, c);
        this.selectedItemList = new JList(this.selectedItemListModel);
        this.selectedItemList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AttributesPropertyDialog.this.deselectAttributesAction.actionPerformed(null);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        ExtendedJScrollPane selectedItemListPane = new ExtendedJScrollPane(this.selectedItemList);
        selectedItemListPane.setBorder(AttributesPropertyDialog.createBorder());
        JPanel selectedItemListPanel = new JPanel(new GridBagLayout());
        c.insets = new Insets(4, 4, 4, 4);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        selectedItemListPanel.add((Component)selectedItemSearchFieldPanel, c);
        c.gridy = 1;
        c.weighty = 1.0;
        selectedItemListPanel.add((Component)selectedItemListPane, c);
        selectedItemListPanel.setBorder(AttributesPropertyDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".selected_attributes.border", new Object[0])));
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)itemListPanel, c);
        JPanel midButtonPanel = new JPanel(new GridLayout(2, 1));
        JButton selectButton = new JButton(this.selectAttributesAction);
        JButton deselectButton = new JButton(this.deselectAttributesAction);
        midButtonPanel.add(deselectButton, 0, 0);
        midButtonPanel.add(selectButton, 1, 0);
        c.insets = new Insets(4, 4, 4, 4);
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 0;
        panel.add((Component)midButtonPanel, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.5;
        c.fill = 1;
        panel.add((Component)selectedItemListPanel, c);
        Dimension d = panel.getPreferredSize();
        d.setSize(d.getWidth() / 2.0, d.getHeight());
        itemListPanel.setPreferredSize(d);
        selectedItemListPanel.setPreferredSize(d);
        this.layoutDefault((JComponent)panel, 1, this.makeOkButton(), this.makeCancelButton());
    }

    public Collection<String> getSelectedAttributeNames() {
        return this.selectedItems;
    }
}

