/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.results;

import com.rapidminer.LoggingListener;
import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.processeditor.results.ResultDisplay;
import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.UpdateQueue;
import com.rapidminer.gui.tools.dialogs.DecisionRememberingConfirmDialog;
import com.rapidminer.gui.viewer.DataTableViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ResultObject;
import com.vlsolutions.swing.docking.DockKey;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class TabbedResultDisplay
extends JPanel
implements ResultDisplay {
    private static final long serialVersionUID = 1970923271834221630L;
    private static final String OPERATOR_TREE_ICON_NAME = "table.png";
    private static final String DEFAULT_RESULT_ICON_NAME = "presentation_chart.png";
    private static Icon dataTableIcon = null;
    static Icon defaultResultIcon = null;
    private final Map<String, Integer> currentResultNames = new TreeMap<String, Integer>();
    private final JTabbedPane tabs = new ExtendedJTabbedPane();
    private final JLabel label = new JLabel("Results");
    private final Collection<DataTable> dataTables = new LinkedList<DataTable>();
    private final UpdateQueue tableUpdateQueue = new UpdateQueue("ResultDisplayDataTableViewUpdater");
    private boolean isAskingForPerspectiveSwitch = false;
    private final LoggingListener logListener = new LoggingListener(){

        @Override
        public void addDataTable(DataTable dataTable) {
            TabbedResultDisplay.this.addDataTable(dataTable);
        }

        @Override
        public void removeDataTable(DataTable dataTable) {
            TabbedResultDisplay.this.dataTables.remove(dataTable);
            TabbedResultDisplay.this.updateDataTables(TabbedResultDisplay.this.dataTables);
        }
    };
    private final ProcessListener processListener = new ProcessListener(){

        @Override
        public void processEnded(Process process) {
        }

        @Override
        public void processFinishedOperator(Process process, Operator op) {
        }

        @Override
        public void processStartedOperator(Process process, Operator op) {
        }

        @Override
        public void processStarts(Process process) {
            TabbedResultDisplay.this.clear();
        }
    };
    private final DockKey DOCK_KEY = new ResourceDockKey("result");
    private Process process;

    public TabbedResultDisplay() {
        super(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.label, "North");
        this.showData(null, "Results");
        this.tableUpdateQueue.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.tabs.removeAll();
        this.dataTables.clear();
        Map<String, Integer> map = this.currentResultNames;
        synchronized (map) {
            this.currentResultNames.clear();
        }
        this.label.setText("No results produced.");
        this.repaint();
    }

    private void updateDataTables(Collection<DataTable> newTableList) {
        final LinkedList<DataTable> copy = new LinkedList<DataTable>(newTableList);
        this.tableUpdateQueue.execute(new Runnable(){

            @Override
            public void run() {
                LinkedList<DataTableViewer> viewers = new LinkedList<DataTableViewer>();
                for (DataTable table : copy) {
                    viewers.add(new DataTableViewer(table, true, 1));
                }
                TabbedResultDisplay.this.installDataTableViewers(viewers);
            }

            public String toString() {
                return "Update data table list to size " + copy.size();
            }
        });
    }

    private void installDataTableViewers(final Collection<DataTableViewer> viewers) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = TabbedResultDisplay.this.tabs.getTabCount() - 1; i >= 0; --i) {
                    Component c = TabbedResultDisplay.this.tabs.getComponentAt(i);
                    if (!(c instanceof DataTableViewer)) continue;
                    TabbedResultDisplay.this.tabs.removeTabAt(i);
                }
                int pos = 0;
                for (DataTableViewer viewer : viewers) {
                    TabbedResultDisplay.this.tabs.insertTab(viewer.getDataTable().getName(), dataTableIcon, viewer, "The data table '" + viewer.getDataTable().getName() + "'.", pos);
                    ++pos;
                }
            }
        });
    }

    @Override
    public void showResult(final ResultObject result) {
        new ProgressThread("creating_display"){

            @Override
            public void run() {
                this.getProgressListener().setTotal(1);
                this.getProgressListener().setCompleted(0);
                TabbedResultDisplay.this.addResultTab(TabbedResultDisplay.this.createComponent(result, null), -2);
                this.getProgressListener().setCompleted(1);
            }
        }.start();
    }

    private void clearResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = TabbedResultDisplay.this.tabs.getTabCount() - 1; i >= 0; --i) {
                    Component c = TabbedResultDisplay.this.tabs.getComponentAt(i);
                    if (c instanceof DataTableViewer) continue;
                    TabbedResultDisplay.this.tabs.removeTabAt(i);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPanel createComponent(ResultObject resultObject, IOContainer resultContainer) {
        String resultName = RendererService.getName(resultObject.getClass());
        String usedResultName = resultObject.getName();
        if (usedResultName == null) {
            usedResultName = resultName;
        }
        Map<String, Integer> map = this.currentResultNames;
        synchronized (map) {
            Integer oldCount = this.currentResultNames.get(usedResultName);
            int myIndex = oldCount == null ? 1 : oldCount + 1;
            this.currentResultNames.put(usedResultName, myIndex);
            if (myIndex > 1) {
                usedResultName = usedResultName + "(" + myIndex + ")";
            }
        }
        return ResultDisplayTools.createVisualizationComponent(resultObject, resultContainer, usedResultName);
    }

    @Override
    public void showData(final IOContainer resultContainer, String message) {
        final int selectedIndex = this.tabs.getSelectedIndex();
        this.clearResults();
        final List<ResultObject> newResults = TabbedResultDisplay.convertToList(resultContainer);
        if (newResults.size() == 0) {
            this.label.setText("No results produced.");
        } else {
            this.label.setText(message);
            new ProgressThread("creating_display"){

                @Override
                public void run() {
                    this.getProgressListener().setTotal(newResults.size());
                    this.getProgressListener().setCompleted(0);
                    int i = 0;
                    for (ResultObject result : newResults) {
                        TabbedResultDisplay.this.addResultTab(TabbedResultDisplay.this.createComponent(result, resultContainer), selectedIndex);
                        this.getProgressListener().setCompleted(++i);
                    }
                }
            }.start();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TabbedResultDisplay.this.tabs.getSelectedIndex() == -1 && TabbedResultDisplay.this.tabs.getTabCount() > 0) {
                    TabbedResultDisplay.this.tabs.setSelectedIndex(0);
                }
            }
        });
    }

    private void addResultTab(final JPanel resultPanel, final int selectMeIfIAmInsertedAsIndex) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedResultDisplay.this.askForPerspectiveSwitch();
                TabbedResultDisplay.this.tabs.addTab((String)resultPanel.getClientProperty("rapidminer.result.name.html"), (Icon)resultPanel.getClientProperty("rapidminer.result.icon"), resultPanel, "Show the result '" + (String)resultPanel.getClientProperty("rapidminer.result.name") + "'.");
                if (selectMeIfIAmInsertedAsIndex == -2 || TabbedResultDisplay.this.tabs.getTabCount() - 1 == selectMeIfIAmInsertedAsIndex) {
                    TabbedResultDisplay.this.tabs.setSelectedIndex(TabbedResultDisplay.this.tabs.getTabCount() - 1);
                }
            }
        });
    }

    public Component getCurrentlyDisplayedComponent() {
        if (this.tabs.getTabCount() == 0) {
            return this.tabs;
        }
        return this.tabs.getSelectedComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void askForPerspectiveSwitch() {
        if (this.isAskingForPerspectiveSwitch || RapidMinerGUI.getMainFrame().getPerspectives().getCurrentPerspective().getName().equals("result")) {
            return;
        }
        try {
            this.isAskingForPerspectiveSwitch = true;
            if (DecisionRememberingConfirmDialog.confirmAction("show_results_on_creation", "rapidminer.gui.auto_switch_to_resultview")) {
                RapidMinerGUI.getMainFrame().getPerspectives().showPerspective("result");
            }
        }
        finally {
            this.isAskingForPerspectiveSwitch = false;
        }
    }

    private static List<ResultObject> convertToList(IOContainer container) {
        LinkedList<ResultObject> list = new LinkedList<ResultObject>();
        if (container != null) {
            ResultObject result = null;
            do {
                try {
                    result = container.get(ResultObject.class, list.size());
                    list.add(result);
                }
                catch (MissingIOObjectException e) {
                    break;
                }
            } while (result != null);
        }
        return list;
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public void addDataTable(DataTable dataTable) {
        this.dataTables.add(dataTable);
        this.updateDataTables(this.dataTables);
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }

    @Override
    public void processChanged(Process process) {
        if (this.process != null) {
            this.process.removeLoggingListener(this.logListener);
            this.process.getRootOperator().removeProcessListener(this.processListener);
        }
        this.process = process;
        if (this.process != null) {
            this.process.addLoggingListener(this.logListener);
            this.process.getRootOperator().addProcessListener(this.processListener);
        }
    }

    @Override
    public void processUpdated(Process process) {
    }

    @Override
    public void setSelection(List<Operator> selection) {
    }

    @Override
    public void init(MainFrame mainFrame) {
    }

    @Override
    public void clearAll() {
    }

    static {
        dataTableIcon = SwingTools.createIcon("16/table.png");
        defaultResultIcon = SwingTools.createIcon("16/presentation_chart.png");
    }
}

