/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.results;

import com.rapidminer.Process;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.flow.ProcessRenderer;
import com.rapidminer.gui.processeditor.results.RapidBorder;
import com.rapidminer.gui.renderer.DefaultTextRenderer;
import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.report.Renderable;
import com.rapidminer.report.Reportable;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryLocation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class SingleResultOverview
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel title;
    private final Component main;
    private String repositoryLocation = null;
    private SoftReference<ResultObject> ioObject;
    static final int MIN_HEIGHT = 300;
    static final int MIN_WIDTH = 300;
    private static final int MAX_RESULT_STRING_LENGTH = 2048;
    private final Action RESTORE_FROM_REPOSITORY = new ResourceAction("resulthistory.restore_data", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressThread downloadProgressThread = new ProgressThread("download_from_repository"){

                @Override
                public void run() {
                    try {
                        RepositoryLocation location = new RepositoryLocation(SingleResultOverview.this.repositoryLocation);
                        Entry entry = location.locateEntry();
                        if (entry instanceof IOObjectEntry) {
                            IOObjectEntry data = (IOObjectEntry)entry;
                            ResultObject result = (ResultObject)data.retrieveData(this.getProgressListener());
                            result.setSource(data.getLocation().toString());
                            RapidMinerGUI.getMainFrame().getResultDisplay().showResult(result);
                        } else {
                            SwingTools.showSimpleErrorMessage("cannot_fetch_data_from_repository", "Not an IOObject.", new Object[0]);
                        }
                    }
                    catch (Exception e1) {
                        SwingTools.showSimpleErrorMessage("cannot_fetch_data_from_repository", (Throwable)e1, new Object[0]);
                    }
                }
            };
            downloadProgressThread.start();
        }
    };
    private final Action OPEN_DATA = new ResourceAction("resulthistory.open_data", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultObject referenced = (ResultObject)SingleResultOverview.this.ioObject.get();
            if (referenced != null) {
                RapidMinerGUI.getMainFrame().getResultDisplay().showResult(referenced);
            }
        }
    };

    public SingleResultOverview(IOObject result, Process process, int resultIndex) {
        InputPort resultPort;
        IOObject other;
        this.setLayout(null);
        this.setOpaque(false);
        MetaData metaData = MetaData.forIOObject(result, true);
        this.setBorder(new RapidBorder(ProcessRenderer.getColorFor(metaData), 15, 35));
        this.setBackground(Color.WHITE);
        if (result instanceof ResultObject) {
            this.ioObject = new SoftReference<ResultObject>((ResultObject)result);
        }
        if (process.getRootOperator().getSubprocess(0).getInnerSinks().getNumberOfPorts() > resultIndex && result == (other = (resultPort = (InputPort)process.getRootOperator().getSubprocess(0).getInnerSinks().getPortByIndex(resultIndex)).getAnyDataOrNull()) && process.getContext().getOutputRepositoryLocations().size() > resultIndex) {
            this.repositoryLocation = process.getContext().getOutputRepositoryLocations().get(resultIndex).toString();
        }
        String name = result.getClass().getSimpleName();
        if (result instanceof ExampleSet) {
            this.main = this.makeMainLabel("<html>" + metaData.getDescription() + "</html>");
            name = ((ResultObject)result).getName();
        } else {
            name = RendererService.getName(result.getClass());
            List<Renderer> renderers = RendererService.getRenderers(name);
            if (renderers.isEmpty()) {
                this.main = this.makeTextRenderer(result);
            } else {
                Component component = null;
                for (Renderer renderer : renderers) {
                    if (!(renderer instanceof DefaultTextRenderer)) {
                        IOContainer dummy = new IOContainer();
                        int imgWidth = 290;
                        int imgHeight = 235;
                        Reportable reportable = renderer.createReportable(result, dummy, imgWidth, imgHeight);
                        if (!(reportable instanceof Renderable)) continue;
                        Renderable renderable = (Renderable)reportable;
                        renderable.prepareRendering();
                        int preferredWidth = renderable.getRenderWidth(800);
                        int preferredHeight = renderable.getRenderHeight(800);
                        final BufferedImage img = new BufferedImage(imgWidth, imgHeight, 1);
                        Graphics2D graphics = (Graphics2D)img.getGraphics();
                        graphics.setColor(Color.WHITE);
                        graphics.fillRect(0, 0, imgWidth, imgHeight);
                        double scale = Math.min((double)imgWidth / (double)preferredWidth, (double)imgHeight / (double)preferredHeight);
                        graphics.scale(scale, scale);
                        renderable.render(graphics, preferredWidth, preferredHeight);
                        component = new JPanel(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            protected void paintComponent(Graphics g) {
                                g.drawImage(img, 0, 0, null);
                            }
                        };
                        break;
                    }
                    component = this.makeTextRenderer(result);
                    break;
                }
                this.main = component == null ? this.makeTextRenderer(result) : component;
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("<html><strong>").append(name);
        b.append("</strong> (").append(result.getSource()).append(")");
        if (this.repositoryLocation != null) {
            b.append("<br/><small>").append(this.repositoryLocation).append("</small>");
        } else {
            b.append("<br/><small>Result not stored in repository.</small>");
        }
        b.append("</html>");
        this.title = new JLabel(b.toString());
        this.add(this.title);
        this.title.setBounds(5, 0, 285, 40);
        this.add(this.main);
        this.main.setBounds(5, 45, 290, 235);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SingleResultOverview.this.showContextMenu(e.getPoint());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SingleResultOverview.this.showContextMenu(e.getPoint());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SingleResultOverview.this.showContextMenu(e.getPoint());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SingleResultOverview.this.main.setBounds(5, 45, SingleResultOverview.this.getWidth() - 10, SingleResultOverview.this.getHeight() - 65);
            }
        });
    }

    private Component makeTextRenderer(IOObject result) {
        if (result instanceof ResultObject) {
            String resultString = ((ResultObject)result).toResultString();
            if (resultString.length() > 2048) {
                resultString = resultString.substring(0, 2048);
            }
            return this.makeMainLabel("<html><pre>" + resultString + "</pre></html>");
        }
        return this.makeMainLabel("No information available.");
    }

    private Component makeMainLabel(String text) {
        ExtendedHTMLJEditorPane label = new ExtendedHTMLJEditorPane("text/html", text);
        StyleSheet css = ((HTMLEditorKit)label.getEditorKit()).getStyleSheet();
        css.addRule("body {font-family:Sans;font-size:11pt}");
        css.addRule("h3 {margin:0; padding:0}");
        css.addRule("h4 {margin-bottom:0; margin-top:1ex; padding:0}");
        css.addRule("p  {margin-top:0; margin-bottom:1ex; padding:0}");
        css.addRule("ul {margin-top:0; margin-bottom:1ex; list-style-image: url(" + this.getClass().getResource("/com/rapidminer/resources/icons/modern/help/circle.png") + ")}");
        css.addRule("ul li {padding-bottom: 2px}");
        css.addRule("li.outPorts {padding-bottom: 0px}");
        css.addRule("ul li ul {margin-top:0; margin-bottom:1ex; list-style-image: url(" + this.getClass().getResource("/com/rapidminer/resources/icons/modern/help/line.png") + ")");
        css.addRule("li ul li {padding-bottom:0}");
        label.setEditable(false);
        label.setBackground(Color.WHITE);
        JScrollPane pane = new JScrollPane(label);
        pane.setBackground(Color.WHITE);
        pane.setBorder(null);
        return pane;
    }

    protected void showContextMenu(Point point) {
        JPopupMenu menu = new JPopupMenu();
        boolean empty = true;
        if (this.repositoryLocation != null) {
            menu.add(this.RESTORE_FROM_REPOSITORY);
            empty = false;
        }
        if (this.ioObject != null && this.ioObject.get() != null) {
            menu.add(this.OPEN_DATA);
            empty = false;
        }
        if (!empty) {
            menu.show(this, (int)point.getX(), (int)point.getY());
        }
    }
}

