/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.results;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.tools.Tools;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ResultTab
extends JPanel
implements Dockable {
    private static final long serialVersionUID = 1L;
    public static final String DOCKKEY_PREFIX = "result_";
    private Component label;
    private Component component;
    private final DockKey dockKey;
    private final String id;

    public ResultTab(String id) {
        this.setLayout(new BorderLayout());
        this.id = id;
        this.dockKey = new DockKey(id, "Result " + id);
        this.dockKey.setDockGroup(MainFrame.DOCK_GROUP_RESULTS);
        this.dockKey.setName(id);
        this.dockKey.setFloatEnabled(true);
        this.label = ResultTab.makeStandbyLabel();
        this.add(this.label, "North");
    }

    public void showResult(final ResultObject resultObject) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ResultTab.this.label != null) {
                    ResultTab.this.remove(ResultTab.this.label);
                    ResultTab.this.label = null;
                }
                if (resultObject != null) {
                    ResultTab.this.dockKey.setName(resultObject.getName() + " (" + resultObject.getSource() + ")");
                    ResultTab.this.dockKey.setTooltip(Tools.toString(resultObject.getProcessingHistory(), " \u2192 "));
                    ResultTab.this.label = ResultTab.makeStandbyLabel();
                    ResultTab.this.add(ResultTab.this.label, "North");
                } else {
                    if (ResultTab.this.id.startsWith("result_process_")) {
                        String number = ResultTab.this.id.substring("result_process_".length());
                        ResultTab.this.label = new ResourceLabel("resulttab.cannot_be_restored_process_result", number);
                        ResultTab.this.dockKey.setName("Result #" + number);
                    } else {
                        ResultTab.this.label = new ResourceLabel("resulttab.cannot_be_restored", new Object[0]);
                        ResultTab.this.dockKey.setName("Result " + ResultTab.this.id);
                    }
                    ((JComponent)ResultTab.this.label).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    ResultTab.this.add(ResultTab.this.label, "North");
                }
                if (ResultTab.this.component != null) {
                    ResultTab.this.remove(ResultTab.this.component);
                }
            }
        });
        if (resultObject != null) {
            final JPanel newComponent = this.createComponent(resultObject, null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ResultTab.this.label != null) {
                        ResultTab.this.remove(ResultTab.this.label);
                        ResultTab.this.label = null;
                    }
                    ResultTab.this.component = newComponent;
                    ResultTab.this.add(ResultTab.this.component, "Center");
                    if (ResultTab.this.component instanceof JComponent) {
                        ResultTab.this.dockKey.setIcon((Icon)((JComponent)ResultTab.this.component).getClientProperty("rapidminer.result.icon"));
                    }
                }
            });
        }
    }

    private static JComponent makeStandbyLabel() {
        ResourceLabel label = new ResourceLabel("resulttab.creating_display", new Object[0]);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return label;
    }

    private JPanel createComponent(ResultObject resultObject, IOContainer resultContainer) {
        String resultName = RendererService.getName(resultObject.getClass());
        String usedResultName = resultObject.getName();
        if (usedResultName == null) {
            usedResultName = resultName;
        }
        return ResultDisplayTools.createVisualizationComponent(resultObject, resultContainer, this.id + ": " + usedResultName);
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.dockKey;
    }

    public void freeResources() {
        if (this.component != null) {
            this.remove(this.component);
            this.component = null;
        }
    }
}

