/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.results;

import com.rapidminer.Process;
import com.rapidminer.gui.processeditor.results.ProcessExecutionResultOverview;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.IOObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ResultOverview
extends JPanel {
    private static final int HISTORY_LENGTH = 50;
    private static final long serialVersionUID = 1L;
    private final LinkedList<ProcessExecutionResultOverview> processOverviews = new LinkedList();
    protected final Action CLEAR_HISTORY_ACTION = new ResourceAction("resulthistory.clear_history", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Iterator i = ResultOverview.this.processOverviews.iterator();
            while (i.hasNext()) {
                ProcessExecutionResultOverview o = (ProcessExecutionResultOverview)i.next();
                i.remove();
                ResultOverview.this.remove(o);
            }
            ResultOverview.this.repaint();
        }
    };

    public ResultOverview() {
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.showContextMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showContextMenu(e);
            }

            private void showContextMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu m = new JPopupMenu();
                    m.add(ResultOverview.this.CLEAR_HISTORY_ACTION);
                    m.show(ResultOverview.this, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void doLayout() {
        int y = 0;
        for (ProcessExecutionResultOverview overview : this.processOverviews) {
            overview.recomputeLayout();
            overview.setBounds(0, y, (int)overview.getPreferredSize().getWidth(), (int)overview.getPreferredSize().getHeight());
            y = (int)((double)y + overview.getPreferredSize().getHeight());
        }
        if (y != this.getHeight()) {
            Dimension total = new Dimension(this.getWidth(), y);
            this.setPreferredSize(total);
            this.setMaximumSize(total);
            this.setMinimumSize(total);
        }
        this.getParent().doLayout();
    }

    public void addResults(Process process, List<IOObject> results, String statusMessage) {
        if (process.getProcessState() != 1 || "true".equals(System.getProperty("rapidminer.gui.add_breakpoint_results_to_history"))) {
            ProcessExecutionResultOverview newOverview = new ProcessExecutionResultOverview(this, process, results, statusMessage);
            this.processOverviews.add(newOverview);
            this.add(newOverview);
            while (this.processOverviews.size() > 50) {
                ProcessExecutionResultOverview first = this.processOverviews.removeFirst();
                this.remove(first);
            }
        }
    }

    public void removeProcessOverview(ProcessExecutionResultOverview processExecutionResultOverview) {
        this.remove(processExecutionResultOverview);
        this.processOverviews.remove(processExecutionResultOverview);
        this.doLayout();
        this.repaint();
    }
}

