/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.results;

import com.rapidminer.gui.processeditor.results.DockableResultDisplay;
import com.rapidminer.gui.processeditor.results.ResultDisplay;
import com.rapidminer.gui.processeditor.results.TabbedResultDisplay;
import com.rapidminer.gui.renderer.DefaultTextRenderer;
import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.RadioCardPanel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ResultDisplayTools {
    static final String CLIENT_PROPERTY_RAPIDMINER_RESULT_NAME_HTML = "rapidminer.result.name.html";
    static final String CLIENT_PROPERTY_RAPIDMINER_RESULT_ICON = "rapidminer.result.icon";
    static final String CLIENT_PROPERTY_RAPIDMINER_RESULT_NAME = "rapidminer.result.name";
    public static final String[] TYPE_NAMES = new String[]{"docking", "tabbed"};

    public static JPanel createVisualizationComponent(IOObject resultObject, IOContainer resultContainer, String usedResultName) {
        String resultName = RendererService.getName(resultObject.getClass());
        List<Renderer> renderers = RendererService.getRenderers(resultName);
        if (resultName == null) {
            renderers.add(new DefaultTextRenderer());
        }
        RadioCardPanel visualisationComponent = new RadioCardPanel(usedResultName, resultObject);
        for (Renderer renderer : renderers) {
            try {
                Component rendererComponent = renderer.getVisualizationComponent(resultObject, resultContainer);
                if (rendererComponent == null) continue;
                visualisationComponent.addCard(renderer.getName(), rendererComponent);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Error creating renderer: " + e, e);
                visualisationComponent.addCard(renderer.getName(), new JLabel("Error creating renderer " + renderer.getName() + " (see log)."));
            }
        }
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.putClientProperty("main.component", visualisationComponent);
        resultPanel.add((Component)visualisationComponent, "Center");
        if (resultObject instanceof ResultObject) {
            if (((ResultObject)resultObject).getResultIcon() != null) {
                resultPanel.putClientProperty(CLIENT_PROPERTY_RAPIDMINER_RESULT_ICON, ((ResultObject)resultObject).getResultIcon());
            } else {
                resultPanel.putClientProperty(CLIENT_PROPERTY_RAPIDMINER_RESULT_ICON, TabbedResultDisplay.defaultResultIcon);
            }
        }
        resultPanel.putClientProperty(CLIENT_PROPERTY_RAPIDMINER_RESULT_NAME, usedResultName);
        resultPanel.putClientProperty(CLIENT_PROPERTY_RAPIDMINER_RESULT_NAME_HTML, "<html>" + usedResultName + "<br/><small>" + resultObject.getSource() + "</small></html>");
        return resultPanel;
    }

    public static ResultDisplay makeResultDisplay() {
        String chosen = System.getProperty("rapidminer.gui.result_display_type");
        if (chosen != null && chosen.equals("tabbed")) {
            return new TabbedResultDisplay();
        }
        return new DockableResultDisplay();
    }
}

