/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.results;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import javax.swing.border.Border;

public class RapidBorder
implements Border {
    private static final Insets INSETS = new Insets(20, 5, 5, 5);
    private final Color color;
    private final int cornerSize;
    private final int headerHeight;

    protected RapidBorder(Color color, int cornerSize, int headerHeight) {
        this.color = color;
        this.cornerSize = cornerSize;
        this.headerHeight = headerHeight;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        GeneralPath border = new GeneralPath();
        border.moveTo(x + this.cornerSize, y);
        border.lineTo(x + --width - this.cornerSize, y);
        border.curveTo(x + width, y, y + width, y, x + width, y + this.cornerSize);
        border.lineTo(x + width, y + --height - this.cornerSize);
        border.curveTo(x + width, y + height, x + width, y + height, x + width - this.cornerSize, y + height);
        border.lineTo(x + this.cornerSize, y + height);
        border.curveTo(x, y + height, x, y + height, x, y + height - this.cornerSize);
        border.lineTo(x, y + this.cornerSize);
        border.curveTo(x, y, x, y, x + this.cornerSize, y);
        if (this.headerHeight > 0) {
            if (height <= this.headerHeight + this.cornerSize) {
                g.setColor(this.color);
                ((Graphics2D)g).fill(border);
            } else {
                g.setColor(c.getBackground());
                ((Graphics2D)g).fill(border);
                GeneralPath header = new GeneralPath();
                header.moveTo(x + this.cornerSize, y);
                header.lineTo(x + width - this.cornerSize, y);
                header.curveTo(x + width, y, y + width, y, x + width, y + this.cornerSize);
                header.lineTo(x + width, y + this.headerHeight);
                header.lineTo(x, y + this.headerHeight);
                header.lineTo(x, y + this.cornerSize);
                header.curveTo(x, y, x, y, x + this.cornerSize, y);
                g.setColor(this.color);
                ((Graphics2D)g).fill(header);
            }
        }
        g.setColor(this.color);
        ((Graphics2D)g).draw(border);
    }
}

