/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.results;

import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.look.ui.ExtensionButtonUI;
import com.rapidminer.gui.processeditor.results.RapidBorder;
import com.rapidminer.gui.processeditor.results.ResultOverview;
import com.rapidminer.gui.processeditor.results.SingleResultOverview;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ProcessExecutionResultOverview
extends JPanel {
    private static final Color[][] COLORS = new Color[][]{{SwingTools.LIGHTEST_BLUE, SwingTools.LIGHT_BLUE}, {SwingTools.LIGHTEST_YELLOW, SwingTools.LIGHT_YELLOW}};
    private static final Map<String, Color[]> processLocationToColor = new HashMap<String, Color[]>();
    private static int lastUsedProcessColor = 0;
    private final Action RESTORE_PROCESS = new ResourceAction(true, "resulthistory.restore_process", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Process process = new Process(ProcessExecutionResultOverview.this.process);
                process.setProcessLocation(ProcessExecutionResultOverview.this.processLocation);
                RapidMinerGUI.getMainFrame().setProcess(process, true);
            }
            catch (Exception e1) {
                SwingTools.showSimpleErrorMessage("cannot_restore_history_process", (Throwable)e1, new Object[0]);
            }
        }
    };
    private final Action REMOVE_FROM_HISTORY = new ResourceAction(true, "resulthistory.remove", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ProcessExecutionResultOverview.this.parent.removeProcessOverview(ProcessExecutionResultOverview.this);
        }
    };
    private final JButton removeButton = new JButton(this.REMOVE_FROM_HISTORY);
    private final JButton restoreButton = new JButton(this.RESTORE_PROCESS);
    private static final long serialVersionUID = 1L;
    private final String process;
    private final ProcessLocation processLocation;
    private final Date terminationTime;
    private final long executionTime;
    private boolean expanded = false;
    private final List<SingleResultOverview> results = new LinkedList<SingleResultOverview>();
    private final ResultOverview parent;
    private final JLabel headerLabel;
    private int columns;
    private int rows;

    public ProcessExecutionResultOverview(ResultOverview parent, Process process, List<IOObject> results, String statusMessage) {
        this.setOpaque(false);
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.restoreButton.setUI(new ExtensionButtonUI());
        this.restoreButton.setMargin(new Insets(0, 0, 0, 0));
        this.restoreButton.setText(null);
        this.restoreButton.setOpaque(false);
        this.add(this.restoreButton);
        this.removeButton.setUI(new ExtensionButtonUI());
        this.removeButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeButton.setText(null);
        this.removeButton.setOpaque(false);
        this.add(this.removeButton);
        Color[] colors = this.getColorFor(process);
        RapidBorder border = new RapidBorder(colors[1], 10, 18);
        this.setBackground(colors[0]);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 5, 10, 5, Color.WHITE), border));
        this.parent = parent;
        this.process = process.getRootOperator().getXML(false);
        this.processLocation = process.getProcessLocation();
        this.terminationTime = new Date();
        this.executionTime = System.currentTimeMillis() - process.getRootOperator().getStartTime();
        String processName = process.getProcessLocation() != null ? process.getProcessLocation().getShortName() : process.getRootOperator().getName();
        StringBuilder b = new StringBuilder();
        b.append("<html><strong>");
        b.append(processName);
        b.append("</strong> (");
        b.append(results.size());
        b.append(" results. <small>");
        b.append(statusMessage);
        b.append("</small>)<br/>Completed: ");
        b.append(DateFormat.getDateTimeInstance().format(this.terminationTime));
        b.append(" (execution time: ").append(Tools.formatDuration(this.executionTime)).append(")");
        b.append("</html>");
        this.headerLabel = new JLabel(b.toString());
        this.headerLabel.setFont(this.headerLabel.getFont().deriveFont(14.0f));
        this.add(this.headerLabel);
        this.headerLabel.setBounds(10, 2, 500, 40);
        int i = 0;
        for (IOObject result : results) {
            SingleResultOverview singleOverview = new SingleResultOverview(result, process, i);
            this.results.add(singleOverview);
            ++i;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProcessExecutionResultOverview.this.showContextMenu(e.getPoint());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProcessExecutionResultOverview.this.showContextMenu(e.getPoint());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProcessExecutionResultOverview.this.showContextMenu(e.getPoint());
                } else {
                    ProcessExecutionResultOverview.this.setExpanded(!ProcessExecutionResultOverview.this.expanded);
                }
            }
        });
    }

    private void setExpanded(boolean expanded) {
        if (expanded != this.expanded) {
            this.expanded = expanded;
            for (SingleResultOverview overview : this.results) {
                if (expanded) {
                    this.add(overview);
                    continue;
                }
                this.remove(overview);
            }
            this.getParent().doLayout();
            this.revalidate();
        }
    }

    void recomputeLayout() {
        Dimension totalSize;
        int parentWidth = this.parent.getWidth();
        if (!this.expanded) {
            totalSize = new Dimension(parentWidth - 30, 50);
        } else {
            int freeWidth = parentWidth - 30;
            this.columns = (int)Math.floor((double)freeWidth / 300.0);
            this.rows = (int)Math.ceil((double)this.results.size() / (double)this.columns);
            int individualWidth = 290;
            int i = 0;
            for (SingleResultOverview overview : this.results) {
                int row = i / this.columns;
                int col = i % this.columns;
                overview.setBounds(10 + col * individualWidth, 45 + row * 300, individualWidth - 5, 290);
                ++i;
            }
            totalSize = new Dimension(parentWidth - 30, this.rows * 300 + 50);
        }
        this.restoreButton.setBounds(new Rectangle((int)totalSize.getWidth() - 48 - 5, 6, (int)this.restoreButton.getPreferredSize().getWidth(), (int)this.restoreButton.getPreferredSize().getHeight()));
        this.removeButton.setBounds(new Rectangle((int)totalSize.getWidth() - 24 - 5, 6, (int)this.restoreButton.getPreferredSize().getWidth(), (int)this.restoreButton.getPreferredSize().getHeight()));
        this.setSize(totalSize);
        this.setPreferredSize(totalSize);
        this.setMinimumSize(totalSize);
        this.setMaximumSize(totalSize);
    }

    private void showContextMenu(Point point) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.RESTORE_PROCESS);
        menu.add(this.REMOVE_FROM_HISTORY);
        menu.add(this.parent.CLEAR_HISTORY_ACTION);
        menu.show(this, (int)point.getX(), (int)point.getY());
    }

    private Color[] getColorFor(Process process) {
        String loc = process.getProcessLocation() == null ? null : ((Object)process.getProcessLocation()).toString();
        Color[] colors = processLocationToColor.get(loc);
        if (colors == null) {
            colors = COLORS[lastUsedProcessColor++ % COLORS.length];
            processLocationToColor.put(loc, colors);
        }
        return colors;
    }
}

