/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.results;

import com.rapidminer.BreakpointListener;
import com.rapidminer.LoggingListener;
import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.processeditor.ProcessLogTab;
import com.rapidminer.gui.processeditor.results.ResultDisplay;
import com.rapidminer.gui.processeditor.results.ResultOverview;
import com.rapidminer.gui.processeditor.results.ResultTab;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.UpdateQueue;
import com.rapidminer.gui.tools.dialogs.DecisionRememberingConfirmDialog;
import com.rapidminer.gui.viewer.DataTableViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.tools.LogService;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import com.vlsolutions.swing.docking.event.DockingActionCloseEvent;
import com.vlsolutions.swing.docking.event.DockingActionDockableEvent;
import com.vlsolutions.swing.docking.event.DockingActionEvent;
import com.vlsolutions.swing.docking.event.DockingActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DockableResultDisplay
extends JPanel
implements ResultDisplay {
    private static final long serialVersionUID = 1L;
    private final DockKey dockKey = new ResourceDockKey("result");
    private final Map<String, DataTable> dataTables = new HashMap<String, DataTable>();
    private final UpdateQueue tableUpdateQueue = new UpdateQueue("ResultDisplayDataTableViewUpdater");
    private final ResultOverview overview = new ResultOverview();
    private boolean isAskingForPerspectiveSwitch = false;
    private static int currentId;
    private final LoggingListener logListener = new LoggingListener(){

        @Override
        public void addDataTable(DataTable dataTable) {
            DockableResultDisplay.this.addDataTable(dataTable);
        }

        @Override
        public void removeDataTable(DataTable dataTable) {
            DockableResultDisplay.this.dataTables.remove(dataTable.getName());
            DockableResultDisplay.this.updateDataTables();
        }
    };
    private final ProcessListener processListener = new ProcessListener(){

        @Override
        public void processEnded(Process process) {
        }

        @Override
        public void processFinishedOperator(Process process, Operator op) {
        }

        @Override
        public void processStartedOperator(Process process, Operator op) {
        }

        @Override
        public void processStarts(Process process) {
            DockableResultDisplay.this.clear();
        }
    };
    private final BreakpointListener breakpointListener = new BreakpointListener(){

        @Override
        public void resume() {
            DockableResultDisplay.this.clear();
        }

        @Override
        public void breakpointReached(Process process, Operator op, IOContainer iocontainer, int location) {
        }
    };
    private Process process;

    public DockableResultDisplay() {
        this.dockKey.setDockGroup(MainFrame.DOCK_GROUP_RESULTS);
        this.setLayout(new BorderLayout());
        ExtendedJScrollPane overviewScrollpane = new ExtendedJScrollPane(this.overview);
        overviewScrollpane.setBorder(null);
        overviewScrollpane.setVerticalScrollBarPolicy(22);
        overviewScrollpane.setHorizontalScrollBarPolicy(31);
        this.add((Component)overviewScrollpane, "Center");
        this.tableUpdateQueue.start();
    }

    @Override
    public void init(MainFrame mf) {
        DockingDesktop desktop = mf.getDockingDesktop();
        desktop.addDockingActionListener(new DockingActionListener(){

            public void dockingActionPerformed(DockingActionEvent arg0) {
            }

            public boolean acceptDockingAction(DockingActionEvent e) {
                if (e instanceof DockingActionCloseEvent && ((DockingActionDockableEvent)e).getDockable() == DockableResultDisplay.this) {
                    return SwingTools.showConfirmDialog("result.really_close", 0, new Object[0]) == 0;
                }
                return true;
            }
        });
        desktop.addDockableStateChangeListener(new DockableStateChangeListener(){

            public void dockableStateChanged(DockableStateChangeEvent e) {
                if (e.getNewState().isClosed()) {
                    ProcessLogTab pt;
                    if (e.getNewState().getDockable() instanceof ResultTab) {
                        ResultTab rt = (ResultTab)e.getNewState().getDockable();
                        rt.freeResources();
                        RapidMinerGUI.getMainFrame().getPerspectives().removeFromAllPerspectives(rt);
                    } else if (e.getNewState().getDockable() instanceof ProcessLogTab && (pt = (ProcessLogTab)e.getNewState().getDockable()) != null) {
                        if (pt.getDataTable() != null) {
                            DockableResultDisplay.this.dataTables.remove(pt.getDataTable().getName());
                        }
                        pt.freeResources();
                        RapidMinerGUI.getMainFrame().getPerspectives().removeFromAllPerspectives(pt);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void askForPerspectiveSwitch() {
        if (this.isAskingForPerspectiveSwitch || RapidMinerGUI.getMainFrame().getPerspectives().getCurrentPerspective().getName().equals("result")) {
            return;
        }
        try {
            this.isAskingForPerspectiveSwitch = true;
            if (DecisionRememberingConfirmDialog.confirmAction("show_results_on_creation", "rapidminer.gui.auto_switch_to_resultview")) {
                if (SwingUtilities.isEventDispatchThread()) {
                    RapidMinerGUI.getMainFrame().getPerspectives().showPerspective("result");
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                RapidMinerGUI.getMainFrame().getPerspectives().showPerspective("result");
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        LogService.getRoot().log(Level.WARNING, "Error switching perspectives: " + e, e);
                    }
                    catch (InvocationTargetException e) {
                        LogService.getRoot().log(Level.WARNING, "Error switching perspectives: " + e, e);
                    }
                }
            }
        }
        finally {
            this.isAskingForPerspectiveSwitch = false;
        }
    }

    @Override
    public void showData(IOContainer container, final String statusMessage) {
        if (container == null || container.size() == 0) {
            return;
        }
        final List<IOObject> ioobjects = Arrays.asList(container.getIOObjects());
        new ProgressThread("creating_display"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.getProgressListener().setTotal(ioobjects.size() + 1);
                    DockableResultDisplay.this.overview.addResults(RapidMinerGUI.getMainFrame().getProcess(), ioobjects, statusMessage);
                    this.getProgressListener().setCompleted(1);
                    int i = 0;
                    for (IOObject ioobject : ioobjects) {
                        if (!(ioobject instanceof ResultObject)) continue;
                        DockableResultDisplay.this.showResultNow((ResultObject)ioobject, "process_" + ++i);
                        this.getProgressListener().setCompleted(i + 1);
                    }
                }
                finally {
                    this.getProgressListener().complete();
                }
            }
        }.start();
        this.askForPerspectiveSwitch();
    }

    @Override
    public void showResult(ResultObject result) {
        this.showResult(result, "dynamic_" + currentId++);
        this.askForPerspectiveSwitch();
    }

    private void showResult(final ResultObject result, final String id) {
        new ProgressThread("creating_display"){

            @Override
            public void run() {
                this.getProgressListener().setTotal(100);
                this.getProgressListener().setCompleted(10);
                DockableResultDisplay.this.showResultNow(result, id);
                this.getProgressListener().setCompleted(100);
                this.getProgressListener().complete();
            }
        }.start();
    }

    private void showResultNow(ResultObject result, String id) {
        ResultTab tab = (ResultTab)RapidMinerGUI.getMainFrame().getDockingDesktop().getContext().getDockableByKey("result_" + id);
        if (tab == null) {
            tab = new ResultTab("result_" + id);
        }
        this.showTab(tab);
        tab.showResult(result);
    }

    private void updateDataTables() {
        final LinkedList<DataTable> copy = new LinkedList<DataTable>(this.dataTables.values());
        this.tableUpdateQueue.execute(new Runnable(){

            @Override
            public void run() {
                LinkedList<DataTableViewer> viewers = new LinkedList<DataTableViewer>();
                for (DataTable table : copy) {
                    viewers.add(new DataTableViewer(table, true, 1));
                }
                DockableResultDisplay.this.installDataTableViewers(viewers);
            }

            public String toString() {
                return "Update data table list to size " + copy.size();
            }
        });
    }

    private void installDataTableViewers(final Collection<DataTableViewer> viewers) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (DataTableViewer viewer : viewers) {
                    ProcessLogTab tab = (ProcessLogTab)RapidMinerGUI.getMainFrame().getDockingDesktop().getContext().getDockableByKey("datatable_" + viewer.getDataTable().getName());
                    if (tab == null) {
                        tab = new ProcessLogTab("datatable_" + viewer.getDataTable().getName());
                    }
                    DockableResultDisplay.this.showTab(tab);
                    tab.setDataTableViewer(viewer);
                }
            }
        });
    }

    private void showTab(final Dockable dockable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RapidMinerGUI.getMainFrame().getPerspectives().showTabInAllPerspectives(dockable, DockableResultDisplay.this);
            }
        });
    }

    @Override
    public void addDataTable(DataTable dataTable) {
        this.dataTables.put(dataTable.getName(), dataTable);
        this.updateDataTables();
    }

    private void clear() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearNow();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DockableResultDisplay.this.clearNow();
                    }
                });
            }
            catch (InterruptedException e) {
                LogService.getRoot().log(Level.WARNING, "Interupted while closing result tabs.", e);
            }
            catch (InvocationTargetException e) {
                LogService.getRoot().log(Level.WARNING, "Exception while closing result tabs: " + e, e);
            }
        }
    }

    private void clearNow() {
        LinkedList<Dockable> toClose = new LinkedList<Dockable>();
        for (DockableState state : RapidMinerGUI.getMainFrame().getDockingDesktop().getContext().getDockables()) {
            if (!state.getDockable().getDockKey().getKey().startsWith("result_process_") && !state.getDockable().getDockKey().getKey().startsWith("datatable_")) continue;
            toClose.add(state.getDockable());
        }
        if (!(toClose.isEmpty() && this.dataTables.isEmpty() || !DecisionRememberingConfirmDialog.confirmAction("result.close_before_run", "rapidminer.gui.close_results_before_run"))) {
            this.dataTables.clear();
            for (Dockable dockable : toClose) {
                if (dockable instanceof ResultTab) {
                    ((ResultTab)dockable).freeResources();
                } else if (dockable instanceof ProcessLogTab) {
                    ((ProcessLogTab)dockable).freeResources();
                }
                RapidMinerGUI.getMainFrame().getPerspectives().removeFromAllPerspectives(dockable);
            }
        }
    }

    @Override
    public void clearAll() {
        for (DockableState state : RapidMinerGUI.getMainFrame().getDockingDesktop().getContext().getDockables()) {
            if (!state.getDockable().getDockKey().getKey().startsWith("result_") && !state.getDockable().getDockKey().getKey().startsWith("datatable_")) continue;
            RapidMinerGUI.getMainFrame().getPerspectives().removeFromAllPerspectives(state.getDockable());
        }
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.dockKey;
    }

    @Override
    public void processChanged(Process process) {
        if (this.process != null) {
            this.process.removeLoggingListener(this.logListener);
            this.process.getRootOperator().removeProcessListener(this.processListener);
            this.process.removeBreakpointListener(this.breakpointListener);
        }
        this.process = process;
        if (this.process != null) {
            this.process.addLoggingListener(this.logListener);
            this.process.getRootOperator().addProcessListener(this.processListener);
            this.process.addBreakpointListener(this.breakpointListener);
        }
    }

    @Override
    public void processUpdated(Process process) {
    }

    @Override
    public void setSelection(List<Operator> selection) {
    }
}

