/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.profiler.data;

import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.ExampleSetFactory;
import com.rapidminer.gui.processeditor.profiler.data.ProfilerData;
import com.rapidminer.repository.RepositoryLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ProfilerDataManager {
    private Map<String, ProfilerData> dataMap;
    private Map<ProcessLocation, Map<String, ProfilerData>> processMap = new HashMap<ProcessLocation, Map<String, ProfilerData>>();
    private RepositoryLocation processMergeLocation;
    private static ProfilerDataManager pdm;
    private static final Logger LOGGER;

    private ProfilerDataManager() {
        this.dataMap = new HashMap<String, ProfilerData>();
    }

    public static synchronized ProfilerDataManager getInstance() {
        if (pdm == null) {
            pdm = new ProfilerDataManager();
        }
        return pdm;
    }

    public ProfilerData getOperatorData(String name) {
        return this.dataMap.get(name);
    }

    public boolean isOperatorDataAvailable(String name) {
        return this.dataMap.get(name) != null;
    }

    public void setProcess(Process process) {
        if (!this.processMap.containsKey(process.getProcessLocation())) {
            this.dataMap = new HashMap<String, ProfilerData>();
            this.processMap.put(process.getProcessLocation(), this.dataMap);
        } else {
            this.dataMap = this.processMap.get(process.getProcessLocation());
        }
    }

    public ProfilerData addOperatorData(Process process, String name, ProfilerData data) {
        if (process == null) {
            throw new IllegalArgumentException("process must not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null!");
        }
        if (data == null) {
            throw new IllegalArgumentException("data must not be null!");
        }
        if (this.isOperatorDataAvailable(name)) {
            LOGGER.warning("Operator data for operator " + name + " already existing!");
            return this.getOperatorData(name);
        }
        this.dataMap.put(name, data);
        return data;
    }

    public void setMergeLocation(RepositoryLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null!");
        }
        this.processMergeLocation = location;
    }

    public RepositoryLocation getMergeLocation() {
        return this.processMergeLocation;
    }

    public void resetAllData() {
        this.processMap.clear();
        this.dataMap.clear();
    }

    public void resetCurrentData() {
        this.dataMap.clear();
    }

    public ExampleSet getProfilingDataAsExampleSet() {
        Object[][] data = new Object[this.dataMap.size()][8];
        int i = 0;
        for (String key : this.dataMap.keySet()) {
            ProfilerData profilerData = this.dataMap.get(key);
            data[i][0] = key;
            data[i][1] = profilerData.getRunCount();
            data[i][2] = profilerData.getLastRunTimeReal();
            data[i][3] = profilerData.getLastRunTimeCpu();
            data[i][4] = profilerData.getAverageRunTimeReal();
            data[i][5] = profilerData.getAverageRunTimeCpu();
            data[i][6] = profilerData.getTotalRunTimeReal();
            data[i][7] = profilerData.getTotalRunTimeCPU();
            ++i;
        }
        ExampleSet example = ExampleSetFactory.createExampleSet(data);
        for (Attribute att : example.getAttributes()) {
            if (att.getName().equals("att1")) {
                att.setName("Operator Name");
                continue;
            }
            if (att.getName().equals("att2")) {
                att.setName("Number of executions");
                continue;
            }
            if (att.getName().equals("att3")) {
                att.setName("Last execution time in ms (real time)");
                continue;
            }
            if (att.getName().equals("att4")) {
                att.setName("Last execution time in ns (cpu time)");
                continue;
            }
            if (att.getName().equals("att5")) {
                att.setName("Average execution time in ms (real time)");
                continue;
            }
            if (att.getName().equals("att6")) {
                att.setName("Average execution time in ns (cpu time)");
                continue;
            }
            if (att.getName().equals("att7")) {
                att.setName("Total execution time in ms (real time)");
                continue;
            }
            if (!att.getName().equals("att8")) continue;
            att.setName("Total execution time in ns (cpu time)");
        }
        return example;
    }

    public ExampleSet getProfilingDataAsMergedExampleSet(ExampleSet existingExample) {
        Serializable example;
        int dataMapSize = this.dataMap.size() + (existingExample != null ? existingExample.size() : 0);
        if (existingExample != null) {
            block0: for (String key : this.dataMap.keySet()) {
                for (int j = 0; j < existingExample.size(); ++j) {
                    Attribute att;
                    example = existingExample.getExample(j);
                    if (!((Example)example).getNominalValue(att = ((Example)example).getAttributes().get("Operator Name")).equals(key)) continue;
                    --dataMapSize;
                    continue block0;
                }
            }
        }
        ArrayList<Example> usedExampleList = new ArrayList<Example>();
        Object[][] data = new Object[dataMapSize][8];
        int i = 0;
        for (String key : this.dataMap.keySet()) {
            boolean found = false;
            ProfilerData profilerData = this.dataMap.get(key);
            if (existingExample != null) {
                for (int j = 0; j < existingExample.size(); ++j) {
                    Attribute att;
                    Example example2 = existingExample.getExample(j);
                    if (!example2.getNominalValue(att = example2.getAttributes().get("Operator Name")).equals(key)) continue;
                    found = true;
                    usedExampleList.add(example2);
                    double newRunCount = example2.getValue(example2.getAttributes().get("Number of executions")) + (double)profilerData.getRunCount();
                    data[i][0] = key;
                    data[i][1] = newRunCount;
                    data[i][2] = profilerData.getLastRunTimeReal() != 0.0 ? profilerData.getLastRunTimeReal() : example2.getValue(example2.getAttributes().get("Last execution time in ms (real time)"));
                    data[i][3] = profilerData.getLastRunTimeCpu() != 0.0 ? profilerData.getLastRunTimeCpu() : example2.getValue(example2.getAttributes().get("Last execution time in ns (cpu time)"));
                    data[i][4] = (example2.getValue(example2.getAttributes().get("Total execution time in ms (real time)")) + profilerData.getTotalRunTimeReal()) / newRunCount;
                    data[i][5] = (example2.getValue(example2.getAttributes().get("Total execution time in ns (cpu time)")) + profilerData.getTotalRunTimeCPU()) / newRunCount;
                    data[i][6] = example2.getValue(example2.getAttributes().get("Total execution time in ms (real time)")) + profilerData.getTotalRunTimeReal();
                    data[i][7] = example2.getValue(example2.getAttributes().get("Total execution time in ns (cpu time)")) + profilerData.getTotalRunTimeCPU();
                    break;
                }
            }
            if (!found) {
                data[i][0] = key;
                data[i][1] = profilerData.getRunCount();
                data[i][2] = profilerData.getLastRunTimeReal();
                data[i][3] = profilerData.getLastRunTimeCpu();
                data[i][4] = profilerData.getAverageRunTimeReal();
                data[i][5] = profilerData.getAverageRunTimeCpu();
                data[i][6] = profilerData.getTotalRunTimeReal();
                data[i][7] = profilerData.getTotalRunTimeCPU();
            }
            ++i;
        }
        if (existingExample != null) {
            for (Example example3 : existingExample) {
                boolean used = false;
                for (Example usedExample : usedExampleList) {
                    if (!example3.getDataRow().equals(usedExample.getDataRow())) continue;
                    used = true;
                    break;
                }
                if (used) continue;
                data[i][0] = example3.getNominalValue(example3.getAttributes().get("Operator Name"));
                data[i][1] = example3.getValue(example3.getAttributes().get("Number of executions"));
                data[i][2] = example3.getValue(example3.getAttributes().get("Last execution time in ms (real time)"));
                data[i][3] = example3.getValue(example3.getAttributes().get("Last execution time in ns (cpu time)"));
                data[i][4] = example3.getValue(example3.getAttributes().get("Average execution time in ms (real time)"));
                data[i][5] = example3.getValue(example3.getAttributes().get("Average execution time in ns (cpu time)"));
                data[i][6] = example3.getValue(example3.getAttributes().get("Total execution time in ms (real time)"));
                data[i][7] = example3.getValue(example3.getAttributes().get("Total execution time in ns (cpu time)"));
                ++i;
            }
        }
        example = ExampleSetFactory.createExampleSet(data);
        for (Attribute att : example.getAttributes()) {
            if (att.getName().equals("att1")) {
                att.setName("Operator Name");
                continue;
            }
            if (att.getName().equals("att2")) {
                att.setName("Number of executions");
                continue;
            }
            if (att.getName().equals("att3")) {
                att.setName("Last execution time in ms (real time)");
                continue;
            }
            if (att.getName().equals("att4")) {
                att.setName("Last execution time in ns (cpu time)");
                continue;
            }
            if (att.getName().equals("att5")) {
                att.setName("Average execution time in ms (real time)");
                continue;
            }
            if (att.getName().equals("att6")) {
                att.setName("Average execution time in ns (cpu time)");
                continue;
            }
            if (att.getName().equals("att7")) {
                att.setName("Total execution time in ms (real time)");
                continue;
            }
            if (!att.getName().equals("att8")) continue;
            att.setName("Total execution time in ns (cpu time)");
        }
        return example;
    }

    static {
        LOGGER = Logger.getLogger(ProfilerDataManager.class.getName());
    }
}

