/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.profiler.data;

public class ProfilerData {
    private long runCount = 0L;
    private double averageRunTimeReal = 0.0;
    private double totalRunTimeReal = 0.0;
    private double lastRunTimeReal = 0.0;
    private double averageRunTimeCpu = 0.0;
    private double totalRunTimeCpu = 0.0;
    private double lastRunTimeCpu = 0.0;

    public boolean hasRun() {
        return this.runCount > 0L;
    }

    public synchronized void incrementRunCount() {
        ++this.runCount;
    }

    public long getRunCount() {
        return this.runCount;
    }

    public double getAverageRunTimeReal() {
        return this.averageRunTimeReal;
    }

    public double getAverageRunTimeRealInSeconds() {
        double value = this.averageRunTimeReal;
        return value /= 1000.0;
    }

    public double getAverageRunTimeCpu() {
        return this.averageRunTimeCpu;
    }

    public double getAverageRunTimeCpuInSeconds() {
        double value = this.averageRunTimeCpu;
        return value /= 1.0E9;
    }

    public synchronized void setLastRunTimeReal(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("time must not be negative!");
        }
        this.lastRunTimeReal = time;
        this.totalRunTimeReal += (double)time;
        this.averageRunTimeReal = this.totalRunTimeReal / (double)this.runCount;
    }

    public synchronized void setLastRunTimeCpu(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("time must not be negative!");
        }
        this.lastRunTimeCpu = time;
        this.totalRunTimeCpu += (double)time;
        this.averageRunTimeCpu = this.totalRunTimeCpu / (double)this.runCount;
    }

    public synchronized double getLastRunTimeReal() {
        return this.lastRunTimeReal;
    }

    public double getLastRunTimeRealInSeconds() {
        double value = this.lastRunTimeReal;
        return value /= 1000.0;
    }

    public synchronized double getLastRunTimeCpu() {
        return this.lastRunTimeCpu;
    }

    public double getLastRunTimeCpuInSeconds() {
        double value = this.lastRunTimeCpu;
        return value /= 1.0E9;
    }

    public double getTotalRunTimeCPU() {
        return this.totalRunTimeCpu;
    }

    public double getTotalRunTimeReal() {
        return this.totalRunTimeReal;
    }
}

