/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.profiler;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.StoreInRepositoryAction;
import com.rapidminer.gui.processeditor.profiler.OperatorProfilePanel;
import com.rapidminer.gui.processeditor.profiler.ProfilingListener;
import com.rapidminer.gui.processeditor.profiler.data.ProfilerDataManager;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.actions.ResetAllProfilerAction;
import com.rapidminer.gui.tools.actions.ResetProfilerAction;
import com.rapidminer.gui.tools.actions.SaveCumulativeProfilerAction;
import com.rapidminer.gui.tools.actions.SaveProfilerAction;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.repository.local.SimpleIOObjectEntry;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class ProfilingViewer
extends JPanel
implements Dockable,
Observer {
    private JPanel innerPanel;
    private JPanel quickbarPanel;
    private ProfilingListener listener;
    private GridBagConstraints gbc;
    public final transient Action RESET_ALL_PROFILING_VIEWER_ACTION = new ResetAllProfilerAction(this);
    public final transient Action RESET_PROFILING_VIEWER_ACTION = new ResetProfilerAction(this);
    public final transient Action SAVE_PROFILING_VIEWER_ACTION = new SaveProfilerAction(this);
    public final transient Action SAVE_CUMULATIVE_PROFILING_VIEWER_ACTION = new SaveCumulativeProfilerAction(this);
    public static final String PROFILING_VIEWER_DOCK_KEY = "profiling_viewer";
    private static final Logger LOGGER = Logger.getLogger(ProfilingViewer.class.getName());
    private static final long serialVersionUID = 8710117784461815725L;
    private final DockKey DOCK_KEY = new ResourceDockKey("profiling_viewer");

    public ProfilingViewer(ProfilingListener listener) {
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null!");
        }
        this.listener = listener;
        listener.addObserver(this);
        this.quickbarPanel = new JPanel();
        this.quickbarPanel.setLayout(new GridBagLayout());
        ExtendedJToolBar toolBar = new ExtendedJToolBar();
        toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        toolBar.add(this.RESET_PROFILING_VIEWER_ACTION);
        toolBar.add(this.RESET_ALL_PROFILING_VIEWER_ACTION);
        toolBar.add(this.SAVE_PROFILING_VIEWER_ACTION);
        toolBar.add(this.SAVE_CUMULATIVE_PROFILING_VIEWER_ACTION);
        JToggleButton toggleMerge = new JToggleButton(new ResourceAction(true, "merge_profiling_toggle_viewer", new Object[0]){
            private static final long serialVersionUID = -3583260287309226987L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilingViewer.this.listener.toggleAutoMerge();
                if (ProfilerDataManager.getInstance().getMergeLocation() == null && ProfilingViewer.this.listener.isAutoMergeEnabled()) {
                    String loc = RepositoryLocationChooser.selectLocation(null, null, RapidMinerGUI.getMainFrame(), true, false);
                    if (loc != null) {
                        try {
                            RepositoryLocation location = new RepositoryLocation(loc);
                            ProfilerDataManager.getInstance().setMergeLocation(location);
                        }
                        catch (Exception ex) {
                            SwingTools.showSimpleErrorMessage("malformed_rep_location", (Throwable)ex, loc);
                        }
                    } else {
                        ProfilingViewer.this.listener.toggleAutoMerge();
                        ((JToggleButton)e.getSource()).setSelected(false);
                    }
                }
            }
        });
        toggleMerge.setText(null);
        toggleMerge.setSelected(false);
        toolBar.add(toggleMerge);
        JToggleButton disableProfiler = new JToggleButton(new ResourceAction(true, "profiling_viewer_enable", new Object[0]){
            private static final long serialVersionUID = -3583260287309226987L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilingViewer.this.listener.toggleProfiling();
            }
        });
        disableProfiler.setText(null);
        disableProfiler.setSelected(false);
        toolBar.add(disableProfiler);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.gbc.weightx = 1.0;
        this.quickbarPanel.add((Component)toolBar, this.gbc);
        this.innerPanel = new JPanel();
        this.innerPanel.setDoubleBuffered(true);
        this.innerPanel.setLayout(new GridBagLayout());
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.innerPanel);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.setDoubleBuffered(true);
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.ipadx = 2;
        this.gbc.ipady = 0;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 11;
        this.gbc.fill = 2;
        this.add((Component)this.quickbarPanel, this.gbc);
        this.gbc.fill = 1;
        this.gbc.weighty = 1.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.ipadx = 2;
        this.gbc.ipady = 0;
        this.gbc.anchor = 10;
        this.add((Component)scrollPane, this.gbc);
    }

    private void updateGui() {
        this.innerPanel.removeAll();
        this.innerPanel.repaint();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(0, 0, 4, 0);
        int y = 0;
        if (this.listener.getSelectedOperatorList().get(0) instanceof ProcessRootOperator) {
            for (Operator op : this.listener.getCurrentProcess().getAllOperators()) {
                this.gbc.gridx = 0;
                this.gbc.gridy = y++;
                this.innerPanel.add((Component)new OperatorProfilePanel(op), this.gbc);
            }
        } else {
            for (Operator op : this.listener.getSelectedOperatorList()) {
                this.gbc.gridx = 0;
                this.gbc.gridy = y++;
                this.innerPanel.add((Component)new OperatorProfilePanel(op), this.gbc);
            }
        }
        this.gbc.weighty = 1.0;
        this.innerPanel.add((Component)new JLabel(), this.gbc);
        this.innerPanel.revalidate();
        this.revalidate();
    }

    public void resetAll() {
        LOGGER.info("Cleared all profiler data.");
        ProfilerDataManager.getInstance().resetAllData();
        this.update(null, null);
    }

    public void resetCurrent() {
        LOGGER.info("Cleared current process profiling data.");
        ProfilerDataManager.getInstance().resetCurrentData();
        this.update(null, null);
    }

    public void saveData() {
        ExampleSet example = ProfilerDataManager.getInstance().getProfilingDataAsExampleSet();
        new StoreInRepositoryAction(example).actionPerformed(null);
        LOGGER.info("Saving profiling data.");
    }

    public void mergeData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String loc = RepositoryLocationChooser.selectLocation(null, null, RapidMinerGUI.getMainFrame(), true, false);
                if (loc != null) {
                    RepositoryLocation location;
                    try {
                        location = new RepositoryLocation(loc);
                    }
                    catch (Exception ex) {
                        SwingTools.showSimpleErrorMessage("malformed_rep_location", (Throwable)ex, loc);
                        return;
                    }
                    try {
                        ExampleSet example;
                        SimpleIOObjectEntry entry = (SimpleIOObjectEntry)location.locateEntry();
                        if (entry != null) {
                            IOObject iooObject = entry.retrieveData(null);
                            ExampleSet existingExample = (ExampleSet)iooObject;
                            example = ProfilerDataManager.getInstance().getProfilingDataAsMergedExampleSet(existingExample);
                        } else {
                            example = ProfilerDataManager.getInstance().getProfilingDataAsMergedExampleSet(null);
                        }
                        RepositoryManager.getInstance(null).store(example, location, null);
                    }
                    catch (RepositoryException ex) {
                        SwingTools.showSimpleErrorMessage("cannot_store_obj_at_location", (Throwable)ex, loc);
                    }
                }
            }
        });
        LOGGER.info("Merging profiling data.");
    }

    private void mergeAutomaticallyData(RepositoryLocation location) {
        try {
            ExampleSet example;
            SimpleIOObjectEntry entry = (SimpleIOObjectEntry)location.locateEntry();
            if (entry != null) {
                IOObject iooObject = entry.retrieveData(null);
                ExampleSet existingExample = (ExampleSet)iooObject;
                example = ProfilerDataManager.getInstance().getProfilingDataAsMergedExampleSet(existingExample);
            } else {
                example = ProfilerDataManager.getInstance().getProfilingDataAsMergedExampleSet(null);
            }
            RepositoryManager.getInstance(null).store(example, location, null);
        }
        catch (RepositoryException ex) {
            SwingTools.showSimpleErrorMessage("cannot_store_obj_at_location", (Throwable)ex, location.getPath());
        }
        LOGGER.info("Auto-Merging profiling data.");
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (Boolean.parseBoolean(String.valueOf(arg)) && this.listener.isAutoMergeEnabled()) {
            this.mergeAutomaticallyData(ProfilerDataManager.getInstance().getMergeLocation());
            this.resetCurrent();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilingViewer.this.updateGui();
            }
        });
    }
}

