/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor.profiler;

import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.processeditor.profiler.data.ProfilerData;
import com.rapidminer.gui.processeditor.profiler.data.ProfilerDataManager;
import com.rapidminer.operator.Operator;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Logger;

public class ProfilingListener
extends Observable
implements ProcessListener,
ProcessEditor {
    private Map<String, Long> operatorExecSystemTimeMap = new HashMap<String, Long>();
    private Map<String, Long> operatorExecCPUTimeMap = new HashMap<String, Long>();
    private Process process;
    private boolean profilingEnabled = false;
    private boolean autoMergeEnabled = false;
    private List<Operator> selectedOperatorList;
    private static final Logger LOGGER = Logger.getLogger(ProfilingListener.class.getName());

    @Override
    public void processEnded(Process process) {
        this.setChanged();
        this.notifyObservers(true);
    }

    protected List<Operator> getSelectedOperatorList() {
        return this.selectedOperatorList;
    }

    protected Process getCurrentProcess() {
        return this.process;
    }

    @Override
    public void processFinishedOperator(Process process, Operator op) {
        if (process != this.process) {
            LOGGER.warning("Process executed did not match currently monitored process!");
        }
        long execTimeReal = Math.abs(this.operatorExecSystemTimeMap.get(op.getName()) - System.currentTimeMillis());
        long execTimeCPU = Math.abs(this.operatorExecCPUTimeMap.get(op.getName()) - ManagementFactory.getThreadMXBean().getThreadCpuTime(Thread.currentThread().getId()));
        ProfilerData data = !ProfilerDataManager.getInstance().isOperatorDataAvailable(op.getName()) ? ProfilerDataManager.getInstance().addOperatorData(process, op.getName(), new ProfilerData()) : ProfilerDataManager.getInstance().getOperatorData(op.getName());
        data.incrementRunCount();
        data.setLastRunTimeReal(execTimeReal);
        data.setLastRunTimeCpu(execTimeCPU);
    }

    @Override
    public void processStartedOperator(Process process, Operator op) {
        this.operatorExecSystemTimeMap.put(op.getName(), System.currentTimeMillis());
        this.operatorExecCPUTimeMap.put(op.getName(), ManagementFactory.getThreadMXBean().getThreadCpuTime(Thread.currentThread().getId()));
    }

    @Override
    public void processStarts(Process process) {
    }

    @Override
    public void processChanged(Process process) {
        if (this.process != null) {
            this.process.getRootOperator().removeProcessListener(this);
        }
        this.process = process;
        ProfilerDataManager.getInstance().setProcess(process);
        if (!this.profilingEnabled) {
            return;
        }
        if (this.process != null) {
            this.process.getRootOperator().addProcessListener(this);
        }
    }

    @Override
    public void processUpdated(Process process) {
    }

    @Override
    public void setSelection(List<Operator> selection) {
        this.selectedOperatorList = new ArrayList<Operator>(selection);
        this.setChanged();
        this.notifyObservers();
    }

    public void disableProfiling() {
        this.profilingEnabled = false;
        if (this.process != null) {
            this.process.getRootOperator().removeProcessListener(this);
        }
    }

    public void enableProfiling() {
        this.profilingEnabled = true;
        if (this.process != null) {
            this.process.getRootOperator().addProcessListener(this);
        }
    }

    public void toggleProfiling() {
        if (this.profilingEnabled) {
            this.disableProfiling();
        } else {
            this.enableProfiling();
        }
    }

    public void toggleAutoMerge() {
        this.autoMergeEnabled = !this.autoMergeEnabled;
    }

    public boolean isAutoMergeEnabled() {
        return this.autoMergeEnabled;
    }
}

